"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterGroup = void 0;
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/filters/filter_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FilterGroup = ({
  filterGroupButtonLabel,
  items,
  onChange
}) => {
  const [isPopoverOpen, {
    off: closePopover,
    toggle
  }] = (0, _reactHooks.useBoolean)(false);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: toggle,
    isSelected: isPopoverOpen,
    numFilters: items.length,
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    numActiveFilters: items.filter(item => item.checked === 'on').length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, filterGroupButtonLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": filterGroupButtonLabel,
    options: items,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              min-width: 220px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, list)));
};
exports.FilterGroup = FilterGroup;