"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaEditorFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18nReact = require("@kbn/i18n-react");
var _sample_preview_table = require("./sample_preview_table");
var _field_summary = require("./field_summary");
var _advanced_field_mapping_options = require("./advanced_field_mapping_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SchemaEditorFlyout = ({
  field,
  stream,
  onClose,
  onStage,
  isEditingByDefault = false,
  withFieldSimulation = false
}) => {
  const [isEditing, toggleEditMode] = (0, _useToggle.default)(isEditingByDefault);
  const [isValidAdvancedFieldMappings, setValidAdvancedFieldMappings] = (0, _react.useState)(true);
  const [isValidSimulation, setValidSimulation] = (0, _react.useState)(true);
  const [isIgnoredField, setIsIgnoredField] = (0, _react.useState)(false);
  const flyoutId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'streams-edit-field'
  });
  const [nextField, setNextField] = (0, _react.useReducer)((prev, updated) => ({
    ...prev,
    ...updated
  }), field);
  const hasValidFieldType = nextField.type !== undefined;
  const onValidate = ({
    isValid,
    isIgnored
  }) => {
    setIsIgnoredField(isIgnored);
    setValidSimulation(isValid);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": flyoutId,
    maxWidth: 500,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, field.name))), isIgnoredField && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.streams.samplePreviewTable.ignoredFieldsCallOutTitle', {
      defaultMessage: 'Ignored field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.samplePreviewTable.ignoredFieldsCallOutMessage",
    defaultMessage: "This field was ignored in some ingested documents due to type mismatch or mapping errors.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_summary.FieldSummary, {
    field: nextField,
    isEditing: isEditing,
    toggleEditMode: toggleEditMode,
    onChange: setNextField,
    stream: stream,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_field_mapping_options.AdvancedFieldMappingOptions, {
    value: nextField.additionalParameters,
    onChange: additionalParameters => setNextField({
      additionalParameters
    }),
    onValidate: setValidAdvancedFieldMappings,
    isEditing: isEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }), withFieldSimulation && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sample_preview_table.SamplePreviewTable, {
    stream: stream,
    nextField: nextField,
    onValidate: onValidate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  })))), isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppSchemaEditorFlyoutCloseButton",
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditorFlyout.closeButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppSchemaEditorFieldStageButton",
    disabled: !hasValidFieldType || !isValidAdvancedFieldMappings || !isValidSimulation,
    onClick: () => {
      onStage({
        ...nextField,
        status: 'mapped'
      });
      if (onClose) onClose();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.fieldForm.stageButtonLabel', {
    defaultMessage: 'Stage changes'
  })))));
};
exports.SchemaEditorFlyout = SchemaEditorFlyout;