"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useControls = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultControls = {
  query: _eui.EuiSearchBar.Query.MATCH_ALL,
  status: [],
  type: []
};
const mergeReducer = (prev, updated) => ({
  ...prev,
  ...updated
});
const useControls = () => (0, _react.useReducer)(mergeReducer, defaultControls);
exports.useControls = useControls;