"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhereBlockSummary = void 0;
var _eui = require("@elastic/eui");
var _streamlang = require("@kbn/streamlang");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@xstate5/react");
var _react3 = require("@emotion/react");
var _create_step_button = require("../../../create_step_button");
var _context_menu = require("../context_menu");
var _block_disable_overlay = require("../block_disable_overlay");
var _shared = require("../../../../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/where/summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WhereBlockSummary = ({
  stepRef,
  rootLevelMap,
  stepUnderEdit,
  level,
  isFirstStepInLevel,
  isLastStepInLevel
}) => {
  const step = (0, _react2.useSelector)(stepRef, snapshot => snapshot.context.step);
  if (!(0, _streamlang.isWhereBlock)(step)) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    css: (0, _react3.css)`
        position: relative;
      `,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, stepUnderEdit && rootLevelMap.get(stepUnderEdit.customIdentifier) === rootLevelMap.get(step.customIdentifier) && /*#__PURE__*/_react.default.createElement(_block_disable_overlay.BlockDisableOverlay, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 54
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react3.css)`
          // Facilitates text truncation
          overflow: hidden;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.ConditionDisplay, {
    condition: step.where,
    showKeyword: true,
    keyword: "WHERE",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react3.css)`
          // Facilitates text truncation for the condition summary
          flex-shrink: 0;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_create_step_button.CreateStepButton, {
    parentId: stepRef.id,
    mode: "inline",
    nestingDisabled: level >= 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_context_menu.StepContextMenu, {
    stepRef: stepRef,
    stepUnderEdit: stepUnderEdit,
    isFirstStepInLevel: isFirstStepInLevel,
    isLastStepInLevel: isLastStepInLevel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))));
};
exports.WhereBlockSummary = WhereBlockSummary;