"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailGeneralData = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _use_timefilter = require("../../../../hooks/use_timefilter");
var _get_stream_type_from_definition = require("../../../../util/get_stream_type_from_definition");
var _use_kibana = require("../../../../hooks/use_kibana");
var _modal = require("./modal");
var _ilm_summary = require("./ilm_summary");
var _ingestion_rate = require("./ingestion_rate");
var _errors = require("../../../../util/errors");
var _retention_card = require("./cards/retention_card");
var _storage_size_card = require("./cards/storage_size_card");
var _ingestion_card = require("./cards/ingestion_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StreamDetailGeneralData = ({
  definition,
  refreshDefinition,
  data
}) => {
  var _definition$privilege, _data$stats, _definition$privilege2, _data$stats2, _data$stats3, _data$stats4, _data$stats5;
  const {
    core: {
      http,
      notifications
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    },
    services: {
      telemetryClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const [isEditModalOpen, setIsEditModalOpen] = (0, _react.useState)(false);
  const [updateInProgress, setUpdateInProgress] = (0, _react.useState)(false);
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const getIlmPolicies = () => http.get('/api/index_lifecycle_management/policies', {
    signal
  });
  const updateLifecycle = async lifecycle => {
    try {
      setUpdateInProgress(true);
      const request = {
        ingest: {
          ...definition.stream.ingest,
          lifecycle
        }
      };
      await streamsRepositoryClient.fetch('PUT /api/streams/{name}/_ingest 2023-10-31', {
        params: {
          path: {
            name: definition.stream.name
          },
          body: request
        },
        signal
      });
      refreshDefinition();
      setIsEditModalOpen(false);
      telemetryClient.trackRetentionChanged(lifecycle, (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(definition.stream));
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.updated', {
          defaultMessage: 'Stream lifecycle updated'
        })
      });
    } catch (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.failed', {
          defaultMessage: 'Failed to update lifecycle'
        }),
        toastMessage: (0, _errors.getFormattedError)(error).message
      });
    } finally {
      setUpdateInProgress(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    css: {
      flexGrow: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, isEditModalOpen && /*#__PURE__*/_react.default.createElement(_modal.EditLifecycleModal, {
    definition: definition,
    closeModal: () => setIsEditModalOpen(false),
    updateLifecycle: updateLifecycle,
    getIlmPolicies: getIlmPolicies,
    updateInProgress: updateInProgress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.generalData', {
    defaultMessage: 'General data'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_retention_card.RetentionCard, {
    definition: definition,
    openEditModal: () => setIsEditModalOpen(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_storage_size_card.StorageSizeCard, {
    hasMonitorPrivileges: (_definition$privilege = definition.privileges) === null || _definition$privilege === void 0 ? void 0 : _definition$privilege.monitor,
    stats: (_data$stats = data.stats) === null || _data$stats === void 0 ? void 0 : _data$stats.ds.stats,
    statsError: data.error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    hasMonitorPrivileges: (_definition$privilege2 = definition.privileges) === null || _definition$privilege2 === void 0 ? void 0 : _definition$privilege2.monitor,
    stats: (_data$stats2 = data.stats) === null || _data$stats2 === void 0 ? void 0 : _data$stats2.ds.stats,
    statsError: data.error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }))), definition.privileges.lifecycle && (0, _streamsSchema.isIlmLifecycle)(definition.effective_lifecycle) ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_ilm_summary.IlmSummary, {
    definition: definition,
    stats: (_data$stats3 = data.stats) === null || _data$stats3 === void 0 ? void 0 : _data$stats3.ds.stats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_ingestion_rate.IngestionRate, {
    definition: definition,
    isLoadingStats: data.isLoading,
    stats: (_data$stats4 = data.stats) === null || _data$stats4 === void 0 ? void 0 : _data$stats4.ds.stats,
    timeState: timeState,
    statsError: data.error,
    aggregations: (_data$stats5 = data.stats) === null || _data$stats5 === void 0 ? void 0 : _data$stats5.ds.aggregations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  })));
};
exports.StreamDetailGeneralData = StreamDetailGeneralData;