"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFailureStoreRedirectLink = void 0;
var _common = require("@kbn/discover-plugin/common");
var _use_kibana = require("../../../../hooks/use_kibana");
var _failure_store_index_name = require("../helpers/failure_store_index_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFailureStoreRedirectLink = ({
  streamName
}) => {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const failureIndexPatterns = (0, _failure_store_index_name.getFailureStoreIndexName)(streamName);
  const esqlQuery = failureIndexPatterns ? `FROM ${failureIndexPatterns}` : undefined;
  const useUrl = share.url.locators.useUrl;
  const discoverLink = useUrl(() => ({
    id: _common.DISCOVER_APP_LOCATOR,
    params: {
      query: {
        esql: esqlQuery || ''
      },
      timeRange: {
        from: 'now-24h',
        to: 'now'
      },
      refreshInterval: {
        pause: true,
        value: 60000
      }
    }
  }), [esqlQuery]);
  return {
    href: discoverLink
  };
};
exports.useFailureStoreRedirectLink = useFailureStoreRedirectLink;