"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeline = Timeline;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _calculateAuto = require("@kbn/calculate-auto");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _streams_chart_tooltip = require("../../streams_chart_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/timeline/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Timeline({
  events,
  start,
  end,
  xFormatter
}) {
  const {
    dependencies: {
      start: {
        charts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const defaultTheme = charts.theme.chartsDefaultBaseTheme;
  const minimalChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    chartPaddings: {
      top: 12,
      bottom: 12
    },
    lineSeriesStyle: {
      fit: {
        line: {
          opacity: 0
        }
      },
      point: {
        opacity: 0
      }
    },
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    }
  };

  // make sure there's nice ticks
  const valuesWithNiceTicks = (0, _react.useMemo)(() => {
    var _calculateAuto$atLeas;
    const delta = (_calculateAuto$atLeas = _calculateAuto.calculateAuto.atLeast(20, _moment.default.duration(end - start))) === null || _calculateAuto$atLeas === void 0 ? void 0 : _calculateAuto$atLeas.asMilliseconds();
    const buckets = Math.floor((end - start) / delta);
    const roundedStart = Math.round(start / delta) * delta;
    return (0, _lodash.range)(0, buckets).map(index => {
      return {
        x: roundedStart + index * delta
      };
    }).concat(events.map(event => {
      return {
        x: event.time
      };
    }));
  }, [start, end, events]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    className: (0, _css.css)`
              white-space: nowrap;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.timeline.title', {
    defaultMessage: 'Timeline'
  })))), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 48
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [minimalChartTheme, baseTheme],
    baseTheme: defaultTheme,
    noResults: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: xFormatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x_axis",
    position: "bottom",
    tickFormat: xFormatter,
    ticks: 20,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y_axis",
    position: "left",
    domain: {
      min: 0,
      max: 100
    },
    hide: true,
    gridLine: {
      opacity: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "dummy",
    data: valuesWithNiceTicks,
    xAccessor: 'x',
    yAccessors: ['x'],
    color: 'rgba(0,0,0,0)',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotations",
    dataValues: events.map(event => ({
      dataValue: event.time,
      event
    })),
    domainType: _charts.AnnotationDomainType.XDomain,
    marker: point => {
      const {
        event
      } = point;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: event.color,
        size: "l",
        className: (0, _css.css)`
                    circle {
                      stroke: ${theme.colors.backgroundBasePlain};
                      stroke-width: 1px;
                    }
                  `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 17
        }
      });
    },
    customTooltip: ({
      datum
    }) => {
      const {
        event
      } = datum;
      return /*#__PURE__*/_react.default.createElement(_streams_chart_tooltip.StreamsChartTooltip, {
        header: event.header,
        color: event.color,
        label: event.label,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 17
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }))));
}