"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatChangePoint = formatChangePoint;
var _i18n = require("@kbn/i18n");
var _p_value_to_label = require("./p_value_to_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getImpactProperties(impact) {
  if (impact === 'high') {
    return {
      color: 'danger',
      label: _i18n.i18n.translate('xpack.streams.significantEventsTable.changePoint.dotImpactHigh', {
        defaultMessage: 'High'
      })
    };
  }
  if (impact === 'medium') {
    return {
      color: 'warning',
      label: _i18n.i18n.translate('xpack.streams.significantEventsTable.changePoint.dotImpactMedium', {
        defaultMessage: 'Medium'
      })
    };
  }
  return {
    color: 'darkShade',
    label: _i18n.i18n.translate('xpack.streams.significantEventsTable.changePoint.dotImpactLow', {
      defaultMessage: 'Low'
    })
  };
}
function formatChangePoint(item) {
  const type = Object.keys(item.change_points.type)[0];
  const isChange = type && type !== 'stationary' && type !== 'non_stationary';
  const point = item.change_points.type[type];
  const pValue = point === null || point === void 0 ? void 0 : point.p_value;
  const changePoint = point === null || point === void 0 ? void 0 : point.change_point;
  const change = isChange && point && pValue !== undefined && changePoint !== undefined ? {
    type,
    impact: (0, _p_value_to_label.pValueToLabel)(pValue),
    time: item.occurrences[changePoint].x,
    p_value: pValue
  } : undefined;
  return change ? {
    ...change,
    ...getImpactProperties(change.impact)
  } : undefined;
}