"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsListEmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _asset_image = require("../asset_image");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/streams_list_empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StreamsListEmptyPrompt = () => {
  var _cloud$serverless, _cloud$serverless2;
  const {
    core: {
      docLinks,
      http
    },
    dependencies: {
      start: {
        spaces,
        share,
        cloud
      }
    }
  } = (0, _use_kibana.useKibana)();
  const streamsDocsLink = docLinks.links.observability.logsStreams;
  const observabilityOnboardingLocator = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);

  // TODO: Replace with a locator when available
  const securityOnboardingLink = `/app/security/${_deeplinksSecurity.SecurityPageName.landing}`;
  const agnosticOnboardingLink = '/app/integrations/browse';
  const spaceObservable = (0, _react.useMemo)(() => spaces ? spaces.getActiveSpace$() : _rxjs.EMPTY, [spaces]);
  const activeSpace = (0, _useObservable.default)(spaceObservable);
  const isObservabilitySpace = (cloud === null || cloud === void 0 ? void 0 : (_cloud$serverless = cloud.serverless) === null || _cloud$serverless === void 0 ? void 0 : _cloud$serverless.projectType) === 'observability' || (activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution) === 'oblt';
  const isSecuritySpace = (cloud === null || cloud === void 0 ? void 0 : (_cloud$serverless2 = cloud.serverless) === null || _cloud$serverless2 === void 0 ? void 0 : _cloud$serverless2.projectType) === 'security' || (activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution) === 'security';
  const onboardingLink = (0, _useAsync.default)(async () => {
    if (observabilityOnboardingLocator && isObservabilitySpace) {
      return await observabilityOnboardingLocator.getUrl({});
    } else if (isSecuritySpace) {
      return http.basePath.prepend(securityOnboardingLink);
    }
    return http.basePath.prepend(agnosticOnboardingLink);
  }, [observabilityOnboardingLocator, isObservabilitySpace, isSecuritySpace, http.basePath, securityOnboardingLink]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      maxInlineSize: '760px !important'
    },
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "addStreams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.emptyState.title', {
      defaultMessage: 'Turn raw data into structured, manageable streams'
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.emptyState.body', {
      defaultMessage: 'Streams provides a centralized UI that streamlines common tasks like rerouting data, extracting fields, or setting data retention, so you don’t need to navigate to multiple applications or manually configure underlying Elasticsearch components.'
    })),
    actions: onboardingLink.value ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: onboardingLink.value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.emptyState.addDataButton', {
      defaultMessage: 'Add data'
    })) : undefined,
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.emptyState.learnMore', {
      defaultMessage: 'Want to learn more? '
    }))), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: streamsDocsLink,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.emptyState.learnMore.link', {
      defaultMessage: ' Read our Streams documentation'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
};
exports.StreamsListEmptyPrompt = StreamsListEmptyPrompt;