"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsSettingsFlyout = StreamsSettingsFlyout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_privileges = require("../../hooks/use_streams_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/streams_settings_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamsSettingsFlyout({
  onClose,
  refreshStreams
}) {
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const context = (0, _use_kibana.useKibana)();
  const {
    dependencies: {
      start: {
        streams: {
          wiredStatus$,
          enableWiredMode,
          disableWiredMode
        }
      }
    },
    core,
    services: {
      telemetryClient
    }
  } = context;
  const {
    ui: {
      manage: canManageWiredKibana
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const [canManageWiredElasticsearch, setCanManageWiredElasticsearch] = _react.default.useState(true);
  const [wiredChecked, setWiredChecked] = _react.default.useState(undefined);
  const [loading, setLoading] = _react.default.useState(true);
  const [showDisableModal, setShowDisableModal] = _react.default.useState(false);
  const [disableConfirmChecked, setDisableConfirmChecked] = _react.default.useState(false);
  const [isDisabling, setIsDisabling] = _react.default.useState(false);
  _react.default.useEffect(() => {
    const sub = wiredStatus$.subscribe(status => {
      setWiredChecked(status.enabled === true);
      setCanManageWiredElasticsearch(Boolean(status.can_manage));
      setLoading(false);
    });
    return () => sub.unsubscribe();
  }, [wiredStatus$]);
  const handleSwitchChange = async () => {
    if (wiredChecked) {
      setShowDisableModal(true);
    } else {
      try {
        setLoading(true);
        await enableWiredMode(signal);
        telemetryClient.trackWiredStreamsStatusChanged({
          is_enabled: true
        });
        refreshStreams();
      } catch (error) {
        var _error$body;
        core.notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.streams.streamsListView.enableWiredStreamsErrorToastTitle', {
            defaultMessage: 'Error updating wired streams setting'
          }),
          toastMessage: (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || (error instanceof Error ? error.message : String(error)),
          toastLifeTimeMs: 5000
        });
      } finally {
        setLoading(false);
      }
    }
  };
  const handleDisableConfirm = async () => {
    setIsDisabling(true);
    try {
      await disableWiredMode(signal);
      telemetryClient.trackWiredStreamsStatusChanged({
        is_enabled: false
      });
      refreshStreams();
      setShowDisableModal(false);
      setDisableConfirmChecked(false);
    } catch (error) {
      var _error$body2;
      core.notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.streamsListView.enableWiredStreamsErrorToastTitle', {
          defaultMessage: 'Error updating wired streams setting'
        }),
        toastMessage: (error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) || (error instanceof Error ? error.message : String(error)),
        toastLifeTimeMs: 5000
      });
    } finally {
      setIsDisabling(false);
      setLoading(false);
    }
  };

  // Shipper button group state
  const shipperButtonGroupPrefix = (0, _eui.useGeneratedHtmlId)({
    prefix: 'shipperButtonGroup'
  });
  const shipperOptions = [{
    id: `${shipperButtonGroupPrefix}__otel`,
    label: 'OTel'
  }, {
    id: `${shipperButtonGroupPrefix}__filebeat`,
    label: 'Filebeat'
  }, {
    id: `${shipperButtonGroupPrefix}__logstash`,
    label: 'Logstash'
  }, {
    id: `${shipperButtonGroupPrefix}__fleet`,
    label: 'Fleet'
  }];
  const [selectedShipperId, setSelectedShipperId] = _react.default.useState(`${shipperButtonGroupPrefix}__otel`);
  const shipperConfigExamples = {
    [`${shipperButtonGroupPrefix}__otel`]: `processors:
  transform/logs-streams:
    log_statements:
      - context: resource
        statements:
          - set(attributes["elasticsearch.index"], "logs")

service:
  pipelines:
    logs:
      receivers: [myreceiver] # works with any logs receiver
      processors: [transform/logs-streams]
      exporters: [elasticsearch, otlp] # works with either`,
    [`${shipperButtonGroupPrefix}__filebeat`]: `filebeat.inputs:
  - type: filestream
    id: my-filestream-id
    index: logs
    enabled: true  
    paths:
      - /var/log/*.log

# No need to install templates for wired streams
setup:
  template:
    enabled: false

output.elasticsearch:
  hosts: ["<elasticsearch-host>"]
  api_key: "<your-api-key>"`,
    [`${shipperButtonGroupPrefix}__logstash`]: `output {
  elasticsearch {
    hosts => ["<elasticsearch-host>"]
    api_key => "<your-api-key>"
    index => "logs"
    action => "create"
  }
}`
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    maxWidth: 700,
    "aria-labelledby": "streamsSettingsFlyoutTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "streamsSettingsFlyoutTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.settingsFlyoutTitle', {
    defaultMessage: 'Streams Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    descriptionFlexItemProps: {
      grow: 2
    },
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.streams.streamsListView.wiredStreamsTitle', {
      defaultMessage: 'Wired Streams'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.streams.streamsListView.betaBadgeLabel', {
        defaultMessage: 'Technical Preview'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.streams.streamsListView.betaBadgeDescription', {
        defaultMessage: 'This functionality is experimental and not supported. It may change or be removed at any time.'
      }),
      alignment: "middle",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 19
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamsListView.wiredStreamsDescription', {
      defaultMessage: 'Send data to Elasticsearch and process it with a clear hierarchy, with inherited settings and managed components. If disabled, some features won’t work as expected.'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.streamsListView.enableWiredStreamsSwitchLabel', {
      defaultMessage: 'Enable wired streams'
    }),
    checked: Boolean(wiredChecked),
    onChange: handleSwitchChange,
    "data-test-subj": "streamsWiredSwitch",
    disabled: !(canManageWiredKibana && canManageWiredElasticsearch),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.shipperConfigTitle', {
    defaultMessage: 'Configure your shippers'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamsListView.shipperConfigDescription",
    defaultMessage: "Send logs data to wired streams. <docLink>Check the documentation</docLink> for more info.",
    values: {
      docLink: (...chunks) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: core.docLinks.links.observability.wiredStreams,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 23
        }
      }, chunks)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.streams.streamsListView.shipperButtonGroupLegend', {
      defaultMessage: 'Select shipper type'
    }),
    options: shipperOptions,
    idSelected: selectedShipperId,
    onChange: setSelectedShipperId,
    buttonSize: "m",
    isFullWidth: false,
    "data-test-subj": "streamsShipperButtonGroup",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 13
    }
  }), selectedShipperId.endsWith('__fleet') ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamsListView.shipperConfigFleetDescription",
    defaultMessage: "Use the <b>Custom Logs (Filestream)</b> integration to send data to Wired Streams:",
    values: {
      b: chunks => /*#__PURE__*/_react.default.createElement("b", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 38
        }
      }, chunks)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.shipperConfigFleetDescriptionStep1', {
    defaultMessage: 'Enable "Write to logs streams" for the output you want to use in the Fleet Settings tab.'
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.shipperConfigFleetDescriptionStep2', {
    defaultMessage: 'Add the Custom Logs (Filestream) integration to an agent policy.'
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.shipperConfigFleetDescriptionStep3', {
    defaultMessage: 'Enable the \'Use the "logs" data stream\' setting in the integration configuration.'
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamsListView.shipperConfigFleetDescriptionStep4', {
    defaultMessage: 'Make sure the agent policy is using the output you configured in step 1.'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    paddingSize: "m",
    "data-test-subj": "streamsShipperConfigExample",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 15
    }
  }, shipperConfigExamples[selectedShipperId])))), showDisableModal && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => {
      setShowDisableModal(false);
      setDisableConfirmChecked(false);
    },
    "aria-labelledby": "streamsWiredDisableModalTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: "streamsWiredDisableModalTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamsSettingsFlyout.disableModalTitle', {
    defaultMessage: 'Disable Wired Streams?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamsSettingsFlyout.disableModalDescription', {
    defaultMessage: 'Disabling Wired Streams will permanently delete all stored data and configuration. This action cannot be undone.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "wiredDisableConfirm",
    checked: disableConfirmChecked,
    onChange: e => setDisableConfirmChecked(e.target.checked),
    label: _i18n.i18n.translate('xpack.streams.streamsSettingsFlyout.disableModalCheckbox', {
      defaultMessage: 'I understand this will delete all data and configuration.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      setShowDisableModal(false);
      setDisableConfirmChecked(false);
    },
    disabled: isDisabling,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamsSettingsFlyout.disableModalCancel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    isLoading: isDisabling,
    disabled: !disableConfirmChecked,
    onClick: handleDisableConfirm,
    "data-test-subj": "streamsWiredDisableConfirmButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamsSettingsFlyout.disableModalDisableButton', {
    defaultMessage: 'Disable Wired Streams'
  })))));
}