"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAIFeatures = useAIFeatures;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _lodash = require("lodash");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _common = require("@kbn/streams-plugin/common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAIFeatures() {
  var _core$application$cap;
  const {
    dependencies: {
      start: {
        observabilityAIAssistant,
        licensing
      }
    },
    core
  } = (0, _use_kibana.useKibana)();
  const isAIAvailableForTier = core.pricing.isFeatureAvailable(_common.STREAMS_TIERED_AI_FEATURE.id);
  const genAiConnectors = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.useGenAIConnectors();
  const license = (0, _useObservable.default)(licensing.license$);
  const [tourCalloutDismissed, setTourCalloutDismissed] = (0, _public.useElasticLlmCalloutDismissed)(_public.ElasticLlmCalloutKey.TOUR_CALLOUT);
  if (!isAIAvailableForTier || !observabilityAIAssistant || !genAiConnectors || genAiConnectors.loading) {
    return null;
  }
  const elasticManagedLlmConnector = (0, _public.getElasticManagedLlmConnector)(genAiConnectors.connectors);
  const enabled = observabilityAIAssistant.service.isEnabled() && !(0, _lodash.isEmpty)(genAiConnectors.connectors);
  const couldBeEnabled = Boolean((license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise')) && ((_core$application$cap = core.application.capabilities.actions) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.save));
  const isManagedAIConnector = elasticManagedLlmConnector ? elasticManagedLlmConnector.id === genAiConnectors.selectedConnector : false;
  return {
    enabled,
    couldBeEnabled,
    genAiConnectors,
    isManagedAIConnector,
    hasAcknowledgedAdditionalCharges: tourCalloutDismissed,
    acknowledgeAdditionalCharges: setTourCalloutDismissed
  };
}