"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWiredStreams = void 0;
var _streamsSchema = require("@kbn/streams-schema");
var _use_kibana = require("./use_kibana");
var _use_streams_app_fetch = require("./use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWiredStreams = () => {
  var _result$value;
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const result = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => streamsRepositoryClient.fetch('GET /api/streams 2023-10-31', {
    signal
  }), [streamsRepositoryClient]);
  return {
    wiredStreams: (_result$value = result.value) === null || _result$value === void 0 ? void 0 : _result$value.streams.filter(_streamsSchema.Streams.WiredStream.Definition.is),
    isLoading: result.loading
  };
};
exports.useWiredStreams = useWiredStreams;