"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareSOForExport = prepareSOForExport;
exports.prepareSOForImport = prepareSOForImport;
exports.referenceManagedIndexPattern = referenceManagedIndexPattern;
exports.savedObjectLinks = savedObjectLinks;
var _uuid = require("uuid");
var _contentPacksSchema = require("@kbn/content-packs-schema");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function prepareSOForExport({
  savedObjects,
  source,
  replacedPatterns = []
}) {
  return savedObjects.filter(_contentPacksSchema.isSupportedSavedObjectType).map(object => {
    const {
      patterns
    } = (0, _contentPacksSchema.findConfiguration)(object);
    const replacements = {
      ...replacedPatterns.reduce((acc, pattern) => {
        acc[pattern] = _contentPacksSchema.INDEX_PLACEHOLDER;
        return acc;
      }, {}),
      ...patterns.filter(pattern => pattern.startsWith(source)).reduce((acc, pattern) => {
        acc[pattern] = pattern.replace(source, _contentPacksSchema.INDEX_PLACEHOLDER);
        return acc;
      }, {})
    };
    return (0, _contentPacksSchema.replaceIndexPatterns)(object, replacements);
  });
}
function prepareSOForImport({
  savedObjects,
  include,
  target,
  links
}) {
  const uniqObjects = (0, _lodash.uniqBy)(savedObjects.filter(object => object.type === 'dashboard' && (0, _contentPacksSchema.isIncludeAll)(include)).flatMap(object => [object, ...(0, _lodash.compact)(object.references.map(ref => savedObjects.find(({
    id,
    type
  }) => id === ref.id && type === ref.type)))]), ({
    id
  }) => id).filter(_contentPacksSchema.isSupportedSavedObjectType).map(object => {
    const {
      patterns
    } = (0, _contentPacksSchema.findConfiguration)(object);
    const replacements = patterns.filter(pattern => pattern.startsWith(_contentPacksSchema.INDEX_PLACEHOLDER)).reduce((acc, pattern) => {
      acc[pattern] = pattern.replace(_contentPacksSchema.INDEX_PLACEHOLDER, target);
      return acc;
    }, {});
    return (0, _contentPacksSchema.replaceIndexPatterns)(object, replacements);
  });
  return updateIds(uniqObjects, links);
}
function updateIds(savedObjects, links) {
  const existingLinks = links.dashboards.flatMap(ref => [ref, ...ref.references]);
  const targetId = ({
    id,
    type
  }) => {
    const link = existingLinks.find(({
      source_id: sourceId
    }) => sourceId === id);
    if (!link) {
      throw new Error(`link for object [type: ${type} | id: ${id}] was not generated`);
    }
    return link.target_id;
  };
  savedObjects.forEach(object => {
    object.id = targetId(object);
    object.references.forEach(ref => {
      // only update the id if the reference is included in the content pack.
      // a missing reference is not necessarily an error condition since it could
      // point to a pre existing saved object, for example logs-* and metrics-*
      // data views
      if (savedObjects.find(so => so.id === ref.id)) {
        ref.id = targetId(ref);
      }
    });
  });
  return savedObjects;
}

// when we import a saved object into a stream we create a copy of the source
// object with a new identifier. a saved object link stores the source identifier
// of an imported object which allows overwriting already imported objects when
// (re)importing a content pack
function savedObjectLinks(savedObjects, existingLinks) {
  const dashboards = savedObjects.filter(object => object.type === 'dashboard').map(object => {
    var _existingLink$target_;
    const existingLink = existingLinks.dashboards.find(({
      source_id: id
    }) => id === object.id);
    return {
      source_id: object.id,
      target_id: (_existingLink$target_ = existingLink === null || existingLink === void 0 ? void 0 : existingLink.target_id) !== null && _existingLink$target_ !== void 0 ? _existingLink$target_ : (0, _uuid.v4)(),
      references: (0, _lodash.uniqBy)(object.references, ref => ref.id)
      // do not generate links for references not included in the content pack
      .filter(ref => savedObjects.find(so => so.id === ref.id)).map(ref => {
        var _existingLink$referen, _existingLink$referen2;
        return {
          source_id: ref.id,
          target_id: (_existingLink$referen = existingLink === null || existingLink === void 0 ? void 0 : (_existingLink$referen2 = existingLink.references.find(existingRef => ref.id === existingRef.source_id)) === null || _existingLink$referen2 === void 0 ? void 0 : _existingLink$referen2.target_id) !== null && _existingLink$referen !== void 0 ? _existingLink$referen : (0, _uuid.v4)()
        };
      })
    };
  });
  return {
    dashboards
  };
}
function referenceManagedIndexPattern(savedObjects) {
  return savedObjects.some(object => object.references.some(ref => ref.type === 'index-pattern' && (ref.id === 'metrics-*' || ref.id === 'logs-*')));
}