"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareStreamsForExport = prepareStreamsForExport;
var _contentPacksSchema = require("@kbn/content-packs-schema");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function prepareStreamsForExport({
  tree
}) {
  return asExportedObjects(tree.name, tree);
}
function asExportedObjects(root, tree) {
  const name = tree.name === root ? _contentPacksSchema.ROOT_STREAM_ID : (0, _helpers.withoutRootPrefix)(root, tree.name);
  const routing = tree.request.stream.ingest.wired.routing.map(({
    destination,
    ...rest
  }) => ({
    ...rest,
    destination: (0, _helpers.withoutRootPrefix)(root, destination)
  }));
  return [{
    type: 'stream',
    name,
    request: {
      ...tree.request,
      stream: {
        ...tree.request.stream,
        ingest: {
          ...tree.request.stream.ingest,
          wired: {
            ...tree.request.stream.ingest.wired,
            routing
          }
        }
      }
    }
  }, ...tree.children.flatMap(child => asExportedObjects(root, child))];
}