"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateClassicIngestPipelineBody = generateClassicIngestPipelineBody;
exports.generateIngestPipeline = generateIngestPipeline;
var _streamsSchema = require("@kbn/streams-schema");
var _streamlang = require("@kbn/streamlang");
var _constants = require("../../../../common/constants");
var _logs_default_pipeline = require("./logs_default_pipeline");
var _name = require("./name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateIngestPipeline(name, definition) {
  const isWiredStream = _streamsSchema.Streams.WiredStream.Definition.is(definition);
  return {
    id: (0, _name.getProcessingPipelineName)(name),
    processors: [...((0, _streamsSchema.isRoot)(definition.name) ? (0, _logs_default_pipeline.getLogsDefaultPipelineProcessors)() : []), ...(!(0, _streamsSchema.isRoot)(definition.name) && isWiredStream ? [{
      script: {
        source: `
                  if (ctx["stream.name"] != params.parentName) {
                    throw new IllegalArgumentException('stream.name is not set properly - did you send the document directly to a child stream instead of the main logs stream?');
                  }
                `,
        lang: 'painless',
        params: {
          parentName: (0, _streamsSchema.getParentId)(definition.name)
        }
      }
    }] : []), {
      script: {
        source: 'ctx["stream.name"] = params.field',
        lang: 'painless',
        params: {
          field: definition.name
        }
      }
    }, ...(isWiredStream ? (0, _streamlang.transpileIngestPipeline)(definition.ingest.processing).processors : []), {
      pipeline: {
        name: `${name}@stream.reroutes`,
        ignore_missing_pipeline: true
      }
    }],
    // root doesn't need flexible access pattern because it can't contain custom processing and default special case processing doesn't work properly with it
    ...(!(0, _streamsSchema.isRoot)(definition.name) ? {
      field_access_pattern: 'flexible'
    } : {}),
    _meta: {
      description: `Default pipeline for the ${name} stream`,
      managed: true
    },
    version: _constants.ASSET_VERSION
  };
}
function generateClassicIngestPipelineBody(definition) {
  const transpiledIngestPipeline = (0, _streamlang.transpileIngestPipeline)(definition.ingest.processing);
  return {
    processors: transpiledIngestPipeline.processors,
    _meta: {
      description: `Stream-managed pipeline for the ${definition.name} stream`,
      managed: true
    },
    // @ts-expect-error @elastic/elasticsearch field - missing in types
    field_access_pattern: 'flexible',
    version: _constants.ASSET_VERSION
  };
}