"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOGS_ROOT_STREAM_NAME = void 0;
exports.hasSupportedStreamsRoot = hasSupportedStreamsRoot;
exports.rootStreamDefinition = void 0;
var _streamsSchema = require("@kbn/streams-schema");
var _logs_layer = require("./component_templates/logs_layer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGS_ROOT_STREAM_NAME = exports.LOGS_ROOT_STREAM_NAME = 'logs';
const rootStreamDefinition = exports.rootStreamDefinition = {
  name: LOGS_ROOT_STREAM_NAME,
  description: 'Root stream',
  ingest: {
    lifecycle: {
      dsl: {}
    },
    settings: {},
    processing: {
      steps: []
    },
    wired: {
      routing: [],
      fields: {
        ..._logs_layer.baseFields
      }
    }
  }
};
function hasSupportedStreamsRoot(streamName) {
  const root = (0, _streamsSchema.getSegments)(streamName)[0];
  return [LOGS_ROOT_STREAM_NAME].includes(root);
}