"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasChangedRetention = hasChangedRetention;
exports.hasFieldOverrides = hasFieldOverrides;
exports.hasProcessingSteps = hasProcessingSteps;
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * If stream does not have a `IngestStreamLifecycleInherit`, retention has been changed
 */
function hasChangedRetention(lifecycle) {
  return lifecycle !== undefined && !(0, _streamsSchema.isInheritLifecycle)(lifecycle);
}

/**
 * Returns true if a Classic stream has one or more processing steps
 */
function hasProcessingSteps(definition) {
  var _definition$ingest, _definition$ingest$pr;
  const processors = (_definition$ingest = definition.ingest) === null || _definition$ingest === void 0 ? void 0 : (_definition$ingest$pr = _definition$ingest.processing) === null || _definition$ingest$pr === void 0 ? void 0 : _definition$ingest$pr.steps;
  return Array.isArray(processors) && processors.length > 0;
}

/**
 * Returns true if a Classic stream defines any field overrides
 */
function hasFieldOverrides(definition) {
  var _definition$ingest$cl, _definition$ingest2, _definition$ingest2$c;
  const fieldOverrides = (_definition$ingest$cl = (_definition$ingest2 = definition.ingest) === null || _definition$ingest2 === void 0 ? void 0 : (_definition$ingest2$c = _definition$ingest2.classic) === null || _definition$ingest2$c === void 0 ? void 0 : _definition$ingest2$c.field_overrides) !== null && _definition$ingest$cl !== void 0 ? _definition$ingest$cl : {};
  return fieldOverrides && Object.keys(fieldOverrides).length > 0;
}