"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupStream = exports.Group = void 0;
var _zod = require("@kbn/zod");
var _base = require("../base");
var _validation = require("../validation/validation");
var _model_validation = require("../validation/model_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Group = exports.Group = (0, _validation.validation)(_zod.z.unknown(), _zod.z.object({
  metadata: _zod.z.record(_zod.z.string()),
  tags: _zod.z.array(_zod.z.string()),
  members: _zod.z.array(_zod.z.string())
}));

/* eslint-disable @typescript-eslint/no-namespace */

const GroupStream = exports.GroupStream = (0, _model_validation.modelValidation)(_base.BaseStream, {
  Source: _zod.z.object({}),
  Definition: _zod.z.object({
    group: Group.right
  }),
  GetResponse: _zod.z.object({}),
  UpsertRequest: _zod.z.object({})
});

// Optimized implementation for Definition check - the fallback is a zod-based check
GroupStream.Definition.is = stream => 'group' in stream;