"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wiredIngestStreamEffectiveSettingsSchema = exports.ingestStreamSettingsSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ingestStreamSettingsSchema = exports.ingestStreamSettingsSchema = _zod.z.object({
  'index.number_of_replicas': _zod.z.optional(_zod.z.object({
    value: _zod.z.number()
  })),
  'index.number_of_shards': _zod.z.optional(_zod.z.object({
    value: _zod.z.number()
  })),
  'index.refresh_interval': _zod.z.optional(_zod.z.object({
    value: _zod.z.union([_zod.z.string(), _zod.z.literal(-1)])
  }))
});
const wiredIngestStreamEffectiveSettingsSchema = exports.wiredIngestStreamEffectiveSettingsSchema = _zod.z.object({
  'index.number_of_replicas': _zod.z.optional(_zod.z.object({
    value: _zod.z.number(),
    from: _zod.z.string()
  })),
  'index.number_of_shards': _zod.z.optional(_zod.z.object({
    value: _zod.z.number(),
    from: _zod.z.string()
  })),
  'index.refresh_interval': _zod.z.optional(_zod.z.object({
    value: _zod.z.union([_zod.z.string(), _zod.z.literal(-1)]),
    from: _zod.z.string()
  }))
});