"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WiredStream = exports.WiredIngest = void 0;
var _zod = require("@kbn/zod");
var _base = require("./base");
var _routing = require("./routing");
var _lifecycle = require("./lifecycle");
var _fields = require("../../fields");
var _validation = require("../validation/validation");
var _model_validation = require("../validation/model_validation");
var _base2 = require("../base");
var _settings = require("./settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-namespace */

const IngestWired = _zod.z.object({
  wired: _zod.z.object({
    fields: _fields.fieldDefinitionSchema,
    routing: _routing.routingDefinitionListSchema
  })
});
const WiredIngest = exports.WiredIngest = (0, _validation.validation)(_base.IngestBase.right, _zod.z.intersection(_base.IngestBase.right, IngestWired));
const WiredStream = exports.WiredStream = (0, _model_validation.modelValidation)(_base2.BaseStream, {
  Definition: _zod.z.intersection(_base.IngestBaseStream.Definition.right, _zod.z.object({
    ingest: IngestWired
  })),
  Source: _zod.z.intersection(_base.IngestBaseStream.Definition.right, _zod.z.object({})),
  GetResponse: _zod.z.intersection(_base.IngestBaseStream.GetResponse.right, _zod.z.object({
    inherited_fields: _fields.inheritedFieldDefinitionSchema,
    effective_lifecycle: _lifecycle.wiredIngestStreamEffectiveLifecycleSchema,
    effective_settings: _settings.wiredIngestStreamEffectiveSettingsSchema
  })),
  UpsertRequest: _zod.z.intersection(_base.IngestBaseStream.UpsertRequest.right, _zod.z.object({}))
});

// Optimized implementation for Definition check - the fallback is a zod-based check
WiredStream.Definition.is = stream => Boolean('ingest' in stream && typeof stream.ingest === 'object' && stream.ingest && 'wired' in stream.ingest);