"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Streams = void 0;
var _model_validation = require("./validation/model_validation");
var _base = require("./base");
var _group = require("./group");
var _ingest = require("./ingest");
var _classic = require("./ingest/classic");
var _wired = require("./ingest/wired");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/no-namespace */
let Streams = exports.Streams = void 0;
(function (_Streams) {
  var ingest = _ingest.IngestStream;
  var WiredStream = _wired.WiredStream;
  var ClassicStream = _classic.ClassicStream;
  var GroupStream = _group.GroupStream;
  const all = _Streams.all = (0, _model_validation.joinValidation)(_base.BaseStream, [ingest.all, GroupStream]);
})(Streams || (exports.Streams = Streams = {}));
Streams.ingest = _ingest.IngestStream;
Streams.WiredStream = _wired.WiredStream;
Streams.ClassicStream = _classic.ClassicStream;
Streams.GroupStream = _group.GroupStream;