"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNonEmptyStringCodec = exports.TimeoutString = exports.SummaryType = exports.StatesIndexStatusType = exports.NameSpaceString = exports.LocationType = exports.InlineScriptString = exports.DateRangeType = exports.CheckGeoType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/fleet-plugin/common");
var _monitor_management = require("../constants/monitor_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NameSpaceString = exports.NameSpaceString = new t.Type('NameSpaceString', t.string.is, (input, context) => {
  if (typeof input === 'string') {
    const {
      error,
      valid
    } = (0, _common.isValidNamespace)(input, true);
    if (!valid) {
      return t.failure(input, context, _i18n.i18n.translate('xpack.synthetics.namespaceValidation.error', {
        defaultMessage: 'Invalid namespace: {error}',
        values: {
          error
        }
      }));
    }
    return t.success(input);
  } else {
    return t.failure(input, context);
  }
}, t.identity);
const TimeoutString = exports.TimeoutString = new t.Type('TimeoutString', t.string.is, (input, context) => {
  if (typeof input === 'string' && input.trim() !== '' && !isNaN(Number(input))) {
    return t.success(input);
  } else {
    return t.failure(input, context);
  }
}, t.identity);
const getNonEmptyStringCodec = fieldName => {
  return new t.Type('NonEmptyString', t.string.is, (input, context) => {
    if (typeof input === 'string' && input.trim() !== '') {
      return t.success(input);
    } else {
      return t.failure(input, context, `Invalid field "${fieldName}", must be a non-empty string.`);
    }
  }, t.identity);
};
exports.getNonEmptyStringCodec = getNonEmptyStringCodec;
const InlineScriptString = exports.InlineScriptString = new t.Type('InlineScriptString', t.string.is, (input, context) => {
  if (typeof input === 'string' && input.trim() !== '') {
    // return false if script contains import or require statement
    if (input.includes('journey(')) {
      return t.failure(input, context, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScript.invalid.type', {
        defaultMessage: '{keyName}: Monitor script is invalid. Inline scripts cannot be full journey scripts, they may only contain step definitions.',
        values: {
          keyName: _monitor_management.ConfigKey.SOURCE_INLINE
        }
      }));
    }
    // should contain at least one step definition
    if (!input.includes('step(')) {
      return t.failure(input, context, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScript.invalid.oneStep.type', {
        defaultMessage: '{keyName}: Monitor script is invalid. Inline scripts must contain at least one step definition.',
        values: {
          keyName: _monitor_management.ConfigKey.SOURCE_INLINE
        }
      }));
    }
    return t.success(input);
  } else {
    if (typeof input === 'string' && input.trim() === '') {
      return t.success(input);
    }
    return t.failure(input, context, `${_monitor_management.ConfigKey.SOURCE_INLINE}: Inline script must be a non-empty string`);
  }
}, t.identity);
const LocationType = exports.LocationType = t.type({
  lat: t.string,
  lon: t.string
});
const CheckGeoType = exports.CheckGeoType = t.intersection([t.type({
  name: t.string
}), t.partial({
  location: LocationType
})]);
const SummaryType = exports.SummaryType = t.partial({
  up: t.number,
  down: t.number,
  geo: CheckGeoType
});
const StatesIndexStatusType = exports.StatesIndexStatusType = t.type({
  indexExists: t.boolean,
  indices: t.string
});
const DateRangeType = exports.DateRangeType = t.type({
  from: t.string,
  to: t.string
});