"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tEnum = tEnum;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This utility function can be used to turn a TypeScript enum into a io-ts codec.
 *
 * @example
 * import { PathReporter } from "io-ts/lib/PathReporter";
 *
 * enum Thing {
 *  FOO = "foo",
 *  BAR = "bar"
 * }
 *
 * const ThingCodec = tEnum<Thing>("Thing", Thing);
 *
 * console.log(PathReporter.report(ThingCodec.decode('invalidvalue')));
 * // prints [ 'Invalid value "invalidvalue" supplied to : Thing' ]
 * console.log(PathReporter.report(ThingCodec.decode('foo')));
 * // prints [ 'No errors!' ]
 */
function tEnum(enumName, theEnum) {
  const isEnumValue = input => Object.values(theEnum).includes(input);
  return new t.Type(enumName, isEnumValue, (input, context) => isEnumValue(input) ? t.success(input) : t.failure(input, context), t.identity);
}