"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailsLinkIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _contexts = require("../../../contexts");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/links/step_details_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepDetailsLinkIcon = ({
  stepIndex,
  checkGroup,
  configId,
  asButton,
  label,
  target = '_self',
  ...commonProps
}) => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)({
    refetchMonitorEnabled: false
  });
  const stepDetailsLink = `${basePath}/app/synthetics/monitor/${configId}/test-run/${checkGroup}/step/${stepIndex}?locationId=${selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id}`;
  if (asButton) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": "syntheticsStepDetailsLinkIconButton"
    }, commonProps, {
      flush: "left",
      iconType: "apmTrace",
      href: stepDetailsLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }), label !== null && label !== void 0 ? label : VIEW_DETAILS);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "syntheticsStepDetailsLinkIconButton"
  }, commonProps, {
    title: VIEW_DETAILS(stepIndex),
    size: "s",
    href: stepDetailsLink,
    target: target,
    iconType: "apmTrace",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }));
};
exports.StepDetailsLinkIcon = StepDetailsLinkIcon;
const VIEW_DETAILS = (stepIndex = 1) => _i18n.i18n.translate('xpack.synthetics.monitor.step.viewStepDetails', {
  defaultMessage: 'View step {stepIndex} details',
  values: {
    stepIndex
  }
});