"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _alert_actions = require("../../monitor_details/monitor_summary/alert_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/links/view_alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsLink = () => {
  const alertUrl = (0, _alert_actions.useAlertsUrl)({
    rangeFrom: 'now-12h/h',
    rangeTo: 'now'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_ALERTS,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "syntheticsAlertsLinkButton",
    "aria-label": VIEW_ALERTS,
    href: alertUrl,
    iconType: "inspect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 7
    }
  }));
};
exports.AlertsLink = AlertsLink;
const VIEW_ALERTS = _i18n.i18n.translate('xpack.synthetics.monitorSummary.viewAlerts', {
  defaultMessage: 'View alerts'
});