"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDurationText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _status_badge = require("./status_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/monitor_test_result/step_duration_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepDurationText = ({
  step
}) => {
  var _step$synthetics$step5, _step$synthetics$step6, _step$synthetics$step7, _step$synthetics$step8;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const stepDuration = (0, _react.useMemo)(() => {
    var _step$synthetics$step, _step$synthetics$step2, _step$synthetics$step3, _step$synthetics$step4;
    const status = (0, _status_badge.parseBadgeStatus)((_step$synthetics$step = (_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.status) !== null && _step$synthetics$step !== void 0 ? _step$synthetics$step : '');
    const color = euiTheme.colors[(0, _status_badge.getTextColorForMonitorStatus)(status)];
    if (status === 'skipped') {
      return {
        text: '-',
        color
      };
    }
    return {
      text: (0, _test_time_formats.formatTestDuration)((_step$synthetics$step3 = step.synthetics.step) === null || _step$synthetics$step3 === void 0 ? void 0 : (_step$synthetics$step4 = _step$synthetics$step3.duration) === null || _step$synthetics$step4 === void 0 ? void 0 : _step$synthetics$step4.us),
      color
    };
  }, [euiTheme.colors, (_step$synthetics$step5 = step.synthetics.step) === null || _step$synthetics$step5 === void 0 ? void 0 : (_step$synthetics$step6 = _step$synthetics$step5.duration) === null || _step$synthetics$step6 === void 0 ? void 0 : _step$synthetics$step6.us, (_step$synthetics$step7 = step.synthetics.step) === null || _step$synthetics$step7 === void 0 ? void 0 : _step$synthetics$step7.status]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: stepDuration.color,
    "data-test-subj": `stepDurationText${(_step$synthetics$step8 = step.synthetics.step) === null || _step$synthetics$step8 === void 0 ? void 0 : _step$synthetics$step8.index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, stepDuration.text);
};
exports.StepDurationText = StepDurationText;