"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEBSITE_URL_LABEL = exports.WEBSITE_URL_HELP_TEXT = exports.URL_REQUIRED_LABEL = exports.URL_INVALID_LABEL = exports.SimpleMonitorForm = exports.MONITOR_SUCCESS_LABEL = exports.MONITOR_FAILURE_LABEL = exports.CREATE_MONITOR_LABEL = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_simple_monitor = require("./use_simple_monitor");
var _service_locations = require("./form_fields/service_locations");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _use_form_wrapped = require("../../../../hooks/use_form_wrapped");
var _permissions = require("../common/components/permissions");
var _is_url_valid = require("../../utils/validators/is_url_valid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/getting_started/simple_monitor_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SimpleMonitorForm = () => {
  const {
    control,
    register,
    handleSubmit,
    formState: {
      isValid,
      isSubmitted
    },
    getFieldState,
    trigger
  } = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onSubmit',
    shouldFocusError: true,
    defaultValues: {
      urls: '',
      locations: []
    }
  });
  const [monitorData, setMonitorData] = (0, _react.useState)();
  const onSubmit = data => {
    setMonitorData(data);
  };
  const {
    loading,
    data: newMonitor
  } = (0, _use_simple_monitor.useSimpleMonitor)({
    monitorData
  });
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const urlFieldState = getFieldState(_runtime_types.ConfigKey.URLS);
  const urlError = isSubmitted || urlFieldState.isTouched ? urlFieldState.error : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: handleSubmit(onSubmit),
    component: "form",
    isInvalid: isSubmitted && !isValid && !loading && !(newMonitor !== null && newMonitor !== void 0 && newMonitor.id),
    noValidate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: WEBSITE_URL_LABEL,
    helpText: urlError ? undefined : WEBSITE_URL_HELP_TEXT,
    isInvalid: !!urlError,
    error: urlError === null || urlError === void 0 ? void 0 : urlError.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true
  }, register(_runtime_types.ConfigKey.URLS, {
    validate: {
      notEmpty: value => !Boolean(value.trim()) ? URL_REQUIRED_LABEL : true,
      notValidUrl: value => !(0, _is_url_valid.isUrlValid)(value) ? URL_INVALID_LABEL : true
    }
  }), {
    isInvalid: !!urlError,
    "data-test-subj": `${_runtime_types.ConfigKey.URLS}-input`,
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_service_locations.ServiceLocationsField, {
    control: control,
    onChange: async _locations => {
      await (trigger === null || trigger === void 0 ? void 0 : trigger());
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    fill: true,
    iconType: "plusInCircleFilled",
    isLoading: loading,
    "data-test-subj": "syntheticsMonitorConfigSubmitButton",
    disabled: !canEditSynthetics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, CREATE_MONITOR_LABEL)))));
};
exports.SimpleMonitorForm = SimpleMonitorForm;
const WEBSITE_URL_LABEL = exports.WEBSITE_URL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.websiteUrlLabel', {
  defaultMessage: 'Website URL'
});
const WEBSITE_URL_HELP_TEXT = exports.WEBSITE_URL_HELP_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.websiteUrlHelpText', {
  defaultMessage: `For example, your company's homepage or https://elastic.co.`
});
const CREATE_MONITOR_LABEL = exports.CREATE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createMonitorLabel', {
  defaultMessage: 'Create monitor'
});
const MONITOR_SUCCESS_LABEL = exports.MONITOR_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorAddedSuccessMessage', {
  defaultMessage: 'Monitor added successfully.'
});
const MONITOR_FAILURE_LABEL = exports.MONITOR_FAILURE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorFailureMessage', {
  defaultMessage: 'Monitor was unable to be saved. Please try again later.'
});
const URL_REQUIRED_LABEL = exports.URL_REQUIRED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.urlRequiredLabel', {
  defaultMessage: 'URL is required'
});
const URL_INVALID_LABEL = exports.URL_INVALID_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.urlInvalidLabel', {
  defaultMessage: 'URL is not valid'
});