"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterContentType = exports.contentTypes = exports.HeaderField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../types");
var _key_value_field = require("./key_value_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/header_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HeaderField = ({
  contentMode,
  defaultValue,
  onChange,
  onBlur,
  'data-test-subj': dataTestSubj,
  readOnly
}) => {
  const defaultValueKeys = Object.keys(defaultValue).filter(filterContentType(defaultValue, contentTypes, contentMode));
  const formattedDefaultValues = [...defaultValueKeys.map(key => {
    return [key || '', defaultValue[key] || '']; // key, value
  })];
  const [headers, setHeaders] = (0, _react.useState)(formattedDefaultValues);
  (0, _react.useEffect)(() => {
    const formattedHeaders = headers.reduce((acc, header) => {
      const [key, value] = header;
      if (key) {
        return {
          ...acc,
          [key]: value
        };
      }
      return acc;
    }, {});
    if (contentMode) {
      onChange({
        'Content-Type': contentTypes[contentMode],
        ...formattedHeaders
      });
    } else {
      onChange(formattedHeaders);
    }
  }, [contentMode, headers, onChange]);
  return /*#__PURE__*/_react.default.createElement(_key_value_field.KeyValuePairsField, {
    addPairControlLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.createPackagePolicy.stepConfigure.headerField.addHeader.label",
      defaultMessage: "Add header",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }),
    defaultPairs: headers,
    onChange: setHeaders,
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    "data-test-subj": dataTestSubj,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};

// We apply default `Content-Type` headers automatically depending on the request body mime type
// We hide the default Content-Type headers from the user as an implementation detail
// However, If the user applies a custom `Content-Type` header, it should be shown
exports.HeaderField = HeaderField;
const filterContentType = (defaultValue, contentTypeMap, contentMode) => key => {
  return key !== 'Content-Type' || key === 'Content-Type' && contentMode && defaultValue[key] !== contentTypeMap[contentMode];
};
exports.filterContentType = filterContentType;
const contentTypes = exports.contentTypes = {
  [_types.CodeEditorMode.JSON]: _types.ContentType.JSON,
  [_types.CodeEditorMode.PLAINTEXT]: _types.ContentType.TEXT,
  [_types.CodeEditorMode.XML]: _types.ContentType.XML,
  [_types.CodeEditorMode.FORM]: _types.ContentType.FORM
};