"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingLatencyField = exports.LATENCY_NEGATIVE_ERROR = exports.LATENCY_LABEL = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _optional_label = require("../optional_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/throttling/throttling_latency_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ThrottlingLatencyField = ({
  throttling,
  readOnly,
  onFieldBlur,
  validate,
  handleInputChange,
  throttlingValue
}) => {
  var _validate$ConfigKey$T, _validate$ConfigKey$T2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: LATENCY_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_label.OptionalLabel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 20
      }
    }),
    isInvalid: validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T !== void 0 && _validate$ConfigKey$T.call(validate, throttling)) : false,
    error: LATENCY_NEGATIVE_ERROR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T2 = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T2 !== void 0 && _validate$ConfigKey$T2.call(validate, throttling)) : false,
    fullWidth: true,
    min: 0,
    value: throttlingValue.latency,
    onChange: event => handleInputChange(event.target.value),
    onBlur: () => onFieldBlur === null || onFieldBlur === void 0 ? void 0 : onFieldBlur('latency'),
    "data-test-subj": "syntheticsBrowserLatency",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, "ms")),
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
exports.ThrottlingLatencyField = ThrottlingLatencyField;
const LATENCY_LABEL = exports.LATENCY_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.latency.label', {
  defaultMessage: 'Latency'
});
const LATENCY_NEGATIVE_ERROR = exports.LATENCY_NEGATIVE_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.latency.error', {
  defaultMessage: 'Latency must not be negative.'
});