"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SCHEDULED_LABEL = exports.TEST_NOW_ARIA_LABEL = exports.RunTestButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
var _test_now_mode_flyout = require("../../test_now_mode/test_now_mode_flyout");
var _formatter = require("./formatter");
var _api = require("../../../state/manual_test_runs/api");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/form/run_test_btn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RunTestButton = ({
  canUsePublicLocations = true,
  isServiceAllowed
}) => {
  var _data$errors;
  const {
    formState,
    getValues,
    handleSubmit
  } = (0, _reactHookForm.useFormContext)();
  const [inProgress, setInProgress] = (0, _react.useState)(false);
  const [testRun, setTestRun] = (0, _react.useState)();
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  const handleTestNow = () => {
    const config = getValues();
    if (config && !Object.keys(formState.errors).length) {
      setInProgress(true);
      setTestRun({
        id: (0, _uuid.v4)(),
        name: config.name,
        monitor: (0, _formatter.format)(config)
      });
    }
  };
  const {
    data,
    loading: isPushing,
    error: serviceError
  } = (0, _public.useFetcher)(() => {
    // in case of test now mode outside of form add/edit, we don't need to trigger since it's already triggered
    if (testRun !== null && testRun !== void 0 && testRun.id) {
      return (0, _api.runOnceMonitor)({
        monitor: testRun.monitor,
        id: testRun.id,
        ...(spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id) ? {
          spaceId
        } : {})
      });
    }
  }, [space === null || space === void 0 ? void 0 : space.id, spaceId, testRun === null || testRun === void 0 ? void 0 : testRun.id, testRun === null || testRun === void 0 ? void 0 : testRun.monitor]);
  const {
    tooltipContent,
    isDisabled
  } = useTooltipContent(formState.isValid, inProgress);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    key: tooltipContent,
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsRunTestBtn",
    color: "success",
    disabled: isDisabled || !canUsePublicLocations || !isServiceAllowed,
    "aria-label": TEST_NOW_ARIA_LABEL,
    iconType: "play",
    onClick: handleSubmit(handleTestNow),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, RUN_TEST)), testRun && /*#__PURE__*/_react.default.createElement(_test_now_mode_flyout.TestNowModeFlyout, {
    serviceError: serviceError,
    errors: (_data$errors = data === null || data === void 0 ? void 0 : data.errors) !== null && _data$errors !== void 0 ? _data$errors : [],
    isPushing: Boolean(isPushing),
    testRun: testRun,
    name: testRun.name,
    inProgress: inProgress,
    onClose: () => {
      setTestRun(undefined);
      setInProgress(false);
    },
    onDone: () => {
      setInProgress(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }));
};
exports.RunTestButton = RunTestButton;
const useTooltipContent = (isValid, isTestRunInProgress) => {
  let tooltipContent = !isValid ? INVALID_DESCRIPTION : TEST_NOW_DESCRIPTION;
  tooltipContent = isTestRunInProgress ? TEST_SCHEDULED_LABEL : tooltipContent;
  const isDisabled = isTestRunInProgress || !isValid;
  return {
    tooltipContent,
    isDisabled
  };
};
const TEST_NOW_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.testRun.description', {
  defaultMessage: 'Test your monitor and verify the results before saving'
});
const INVALID_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.testRun.invalid', {
  defaultMessage: 'Monitor has to be valid to run test, please fix above required fields.'
});
const TEST_SCHEDULED_LABEL = exports.TEST_SCHEDULED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.testNow.scheduled', {
  defaultMessage: 'Test is already scheduled'
});
const TEST_NOW_ARIA_LABEL = exports.TEST_NOW_ARIA_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.testNow.AriaLabel', {
  defaultMessage: 'Click to run test now'
});
const RUN_TEST = _i18n.i18n.translate('xpack.synthetics.monitorList.runTest.label', {
  defaultMessage: 'Run test'
});