"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_MONITOR_STEPS = exports.ADD_MONITOR_STEPS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _types = require("../types");
var _step_fields = require("./step_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/steps/step_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MONITOR_TYPE_STEP = {
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorTypeStep.title', {
    defaultMessage: 'Select a monitor type'
  }),
  children: /*#__PURE__*/_react.default.createElement(_step_fields.StepFields, {
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorTypeStep.description', {
      defaultMessage: 'Choose a monitor that best fits your use case'
    })),
    stepKey: "step1",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  })
};
const MONITOR_DETAILS_STEP = (readOnly = false) => ({
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorDetailsStep.title', {
    defaultMessage: 'Monitor details'
  }),
  children: /*#__PURE__*/_react.default.createElement(_step_fields.StepFields, {
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorDetailsStep.description', {
      defaultMessage: 'Provide some details about how your monitor should run'
    })),
    stepKey: "step2",
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  })
});
const SCRIPT_RECORDER_BTNS = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexStart",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  "data-test-subj": "syntheticsLaunchSyntheticsRecorderButton",
  href: `elastic-synthetics-recorder://`,
  iconType: "popout",
  iconSide: "right",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 7
  }
}, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScriptStep.scriptRecorder.launch', {
  defaultMessage: 'Launch Synthetics Recorder'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "syntheticsDownloadSyntheticsRecorderButton",
  href: "https://github.com/elastic/synthetics-recorder/blob/main/docs/DOWNLOAD.md",
  iconType: "download",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 7
  }
}, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScriptStep.scriptRecorder.download', {
  defaultMessage: 'Download Synthetics Recorder'
}))));
const MONITOR_SCRIPT_STEP = {
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScriptStep.title', {
    defaultMessage: 'Add a script'
  }),
  children: /*#__PURE__*/_react.default.createElement(_step_fields.StepFields, {
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.monitorScriptStep.description",
      defaultMessage: "Use Elastic Synthetics Recorder to generate a script and then upload it. Alternatively, you can write your own {playwright} script and paste it in the script editor.",
      values: {
        playwright: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "syntheticsPlaywrightLink",
          href: "https://playwright.dev/",
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.monitorConfig.monitorScriptStep.playwrightLink",
          defaultMessage: "Playwright",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 103,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    })), SCRIPT_RECORDER_BTNS),
    stepKey: "step3",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  })
};
const MONITOR_SCRIPT_STEP_EDIT = (readOnly = false) => ({
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorScriptEditStep.title', {
    defaultMessage: 'Monitor script'
  }),
  children: /*#__PURE__*/_react.default.createElement(_step_fields.StepFields, {
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, readOnly ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.monitorScriptEditStepReadOnly.description",
      defaultMessage: "You can only view and edit the script in the source file of the monitor.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.monitorScriptEditStep.description",
      defaultMessage: "Use Elastic Synthetics Recorder to generate and upload a script. Alternatively, you can edit the existing {playwright} script (or paste a new one) in the script editor.",
      values: {
        playwright: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "syntheticsMONITOR_SCRIPT_STEP_EDITPlaywrightLink",
          href: "https://playwright.dev/",
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.monitorConfig.monitorScriptEditStep.playwrightLink",
          defaultMessage: "Playwright",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    })), readOnly ? null : SCRIPT_RECORDER_BTNS),
    stepKey: "scriptEdit",
    readOnly: readOnly,
    descriptionOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  })
});
const ADD_MONITOR_STEPS = exports.ADD_MONITOR_STEPS = {
  [_types.FormMonitorType.MULTISTEP]: [MONITOR_TYPE_STEP, MONITOR_DETAILS_STEP(), MONITOR_SCRIPT_STEP],
  [_types.FormMonitorType.SINGLE]: [MONITOR_TYPE_STEP, MONITOR_DETAILS_STEP()],
  [_types.FormMonitorType.HTTP]: [MONITOR_TYPE_STEP, MONITOR_DETAILS_STEP()],
  [_types.FormMonitorType.ICMP]: [MONITOR_TYPE_STEP, MONITOR_DETAILS_STEP()],
  [_types.FormMonitorType.TCP]: [MONITOR_TYPE_STEP, MONITOR_DETAILS_STEP()]
};
const EDIT_MONITOR_STEPS = readOnly => ({
  [_types.FormMonitorType.MULTISTEP]: [MONITOR_SCRIPT_STEP_EDIT(readOnly), MONITOR_DETAILS_STEP(readOnly)],
  [_types.FormMonitorType.SINGLE]: [MONITOR_DETAILS_STEP(readOnly)],
  [_types.FormMonitorType.HTTP]: [MONITOR_DETAILS_STEP(readOnly)],
  [_types.FormMonitorType.ICMP]: [MONITOR_DETAILS_STEP(readOnly)],
  [_types.FormMonitorType.TCP]: [MONITOR_DETAILS_STEP(readOnly)]
});
exports.EDIT_MONITOR_STEPS = EDIT_MONITOR_STEPS;