"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorNotFoundPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _create_monitor_button = require("../monitors_page/create_monitor_button");
var _plugin = require("../../../../../common/constants/plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_not_found_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorNotFoundPage = () => {
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPromptNotFound.NotFoundPrompt, {
    title: NOT_FOUND_TITLE,
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.prompt.errors.notFound.body",
      defaultMessage: "Sorry, the monitor with id {monitorId} can't be found. It might have been removed or you don't have permissions to view it.",
      values: {
        monitorId: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 30,
            columnNumber: 32
          }
        }, monitorId)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }),
    actions: [/*#__PURE__*/_react.default.createElement(_create_monitor_button.CreateMonitorButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsMonitorNotFoundPageGoToHomeButton",
      iconType: "arrowLeft",
      flush: "both",
      onClick: () => {
        application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.routes.createNewMonitor', {
      defaultMessage: 'Go to Home'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
};
exports.MonitorNotFoundPage = MonitorNotFoundPage;
const NOT_FOUND_TITLE = _i18n.i18n.translate('xpack.synthetics.prompt.errors.notFound.title', {
  defaultMessage: 'Monitor not found'
});