"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _monitor_status_header = require("./monitor_status_header");
var _monitor_status_cell_tooltip = require("./monitor_status_cell_tooltip");
var _monitor_status_legend = require("./monitor_status_legend");
var _monitor_status_chart_theme = require("./monitor_status_chart_theme");
var _monitor_status_data = require("./monitor_status_data");
var _use_monitor_status_data = require("./use_monitor_status_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_status/monitor_status_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorStatusPanel = ({
  from = 'now-24h',
  to = 'now',
  brushable = true,
  periodCaption = undefined,
  showViewHistoryButton = false,
  onBrushed
}) => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const initialSizeRef = (0, _react.useRef)(null);
  const {
    loading,
    timeBins,
    handleResize,
    getTimeBinByXValue,
    xDomain,
    minsPerBin
  } = (0, _use_monitor_status_data.useMonitorStatusData)({
    from,
    to,
    initialSizeRef
  });
  const {
    charts
  } = (0, _public.useKibana)().services;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const heatmap = (0, _react.useMemo)(() => {
    return (0, _monitor_status_chart_theme.getMonitorStatusChartTheme)(euiTheme, brushable);
  }, [euiTheme, brushable]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_status_header.MonitorStatusHeader, {
    from: from,
    to: to,
    brushable: brushable,
    periodCaption: periodCaption,
    showViewHistoryButton: showViewHistoryButton,
    onBrushed: onBrushed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: initialSizeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: e => handleResize(e),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, minsPerBin && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 80
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    customTooltip: ({
      values
    }) => {
      var _values$, _values$$datum;
      return /*#__PURE__*/_react.default.createElement(_monitor_status_cell_tooltip.MonitorStatusCellTooltip, {
        timeBin: getTimeBinByXValue(values === null || values === void 0 ? void 0 : (_values$ = values[0]) === null || _values$ === void 0 ? void 0 : (_values$$datum = _values$.datum) === null || _values$$datum === void 0 ? void 0 : _values$$datum.x),
        isLoading: loading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 23
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    xDomain: xDomain,
    theme: {
      heatmap
    },
    baseTheme: baseTheme,
    onBrushEnd: brushArea => {
      onBrushed === null || onBrushed === void 0 ? void 0 : onBrushed((0, _monitor_status_data.getBrushData)(brushArea));
    },
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Heatmap, {
    id: "monitor-details-monitor-status-chart",
    colorScale: {
      type: 'bands',
      bands: (0, _monitor_status_data.getColorBands)(euiTheme, colorMode)
    },
    data: timeBins,
    xAccessor: ({
      end
    }) => end,
    yAccessor: () => 'T',
    valueAccessor: timeBin => timeBin.value,
    valueFormatter: d => d.toFixed(2),
    xAxisLabelFormatter: (0, _monitor_status_data.getXAxisLabelFormatter)(minsPerBin),
    timeZone: "UTC",
    xScale: {
      type: _charts.ScaleType.Time,
      interval: {
        type: 'calendar',
        unit: 'm',
        value: minsPerBin
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_monitor_status_legend.MonitorStatusLegend, {
    brushable: brushable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 19
    }
  }));
};
exports.MonitorStatusPanel = MonitorStatusPanel;