"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunsTableHeader = exports.LAST_10_TEST_RUNS = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _status_filter = require("./status_filter");
var _constants = require("../../../../../../common/constants");
var _runtime_types = require("../../../../../../common/runtime_types");
var _hooks = require("../../../hooks");
var _url_params = require("../../../utils/url_params");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/test_runs_table_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TestRunsTableHeader = ({
  pings,
  paginable,
  showViewHistoryButton = true
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const params = (0, _hooks.useGetUrlParams)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "l",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, paginable || (pings === null || pings === void 0 ? void 0 : pings.length) < 10 ? TEST_RUNS : LAST_10_TEST_RUNS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, showViewHistoryButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsTestRunsTableHeaderLink",
    href: monitor !== null && monitor !== void 0 && monitor[_runtime_types.ConfigKey.CONFIG_ID] ? history.createHref({
      pathname: _constants.MONITOR_HISTORY_ROUTE.replace(':monitorId', monitor[_runtime_types.ConfigKey.CONFIG_ID]),
      search: (0, _url_params.stringifyUrlParams)({
        ...params,
        dateRangeStart: 'now-24h',
        dateRangeEnd: 'now'
      }, true)
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "monitorStatusChartViewHistoryButton",
    size: "xs",
    iconType: "list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.viewHistory', {
    defaultMessage: 'View History'
  }))) : null));
};
exports.TestRunsTableHeader = TestRunsTableHeader;
const TEST_RUNS = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.testRuns', {
  defaultMessage: 'Test Runs'
});
const LAST_10_TEST_RUNS = exports.LAST_10_TEST_RUNS = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.lastTenTestRuns', {
  defaultMessage: 'Last 10 Test Runs'
});