"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunTestManuallyContextItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _contexts = require("../../contexts");
var _use_kibana_space = require("../../../../hooks/use_kibana_space");
var _permissions = require("../common/components/permissions");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _monitor_management = require("../../../../../common/constants/monitor_management");
var _run_test_btn = require("../monitor_add_edit/form/run_test_btn");
var _use_selected_monitor = require("./hooks/use_selected_monitor");
var _manual_test_runs = require("../../state/manual_test_runs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/run_test_manually.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RunTestManuallyContextItem = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const testInProgress = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunInProgressSelector)(monitor === null || monitor === void 0 ? void 0 : monitor.config_id));
  const canUsePublicLocations = (0, _use_capabilities.useCanUsePublicLocations)(monitor === null || monitor === void 0 ? void 0 : monitor[_monitor_management.ConfigKey.LOCATIONS]);
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const content = testInProgress ? _run_test_btn.TEST_SCHEDULED_LABEL : _run_test_btn.TEST_NOW_ARIA_LABEL;
  return /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    content: content,
    canEditSynthetics: canSave,
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "syntheticsRunTestManuallyButton",
    color: "success",
    disabled: !canUsePublicLocations || !canSave,
    onClick: () => {
      if (monitor) {
        const spaceId = 'spaceId' in monitor ? monitor.spaceId : undefined;
        dispatch(_manual_test_runs.manualTestMonitorAction.get({
          configId: monitor.config_id,
          name: monitor.name,
          ...(spaceId && spaceId !== (space === null || space === void 0 ? void 0 : space.id) ? {
            spaceId
          } : {})
        }));
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, testInProgress ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 31
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 64
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 38
    }
  }, RUN_TEST_LABEL)))));
};
exports.RunTestManuallyContextItem = RunTestManuallyContextItem;
const RUN_TEST_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorSummary.runTestManually', {
  defaultMessage: 'Run test manually'
});