"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorDetailsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../../common/constants");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_breadcrumbs = require("../monitors_page/hooks/use_breadcrumbs");
var _use_selected_monitor = require("./hooks/use_selected_monitor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/use_monitor_details_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useMonitorDetailsPage = () => {
  var _monitor$name;
  const {
    monitor,
    isMonitorMissing
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  (0, _use_breadcrumbs.useMonitorListBreadcrumbs)(monitor ? [{
    text: (_monitor$name = monitor === null || monitor === void 0 ? void 0 : monitor.name) !== null && _monitor$name !== void 0 ? _monitor$name : ''
  }] : []);
  if (isMonitorMissing && (monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== monitorId) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.MONITOR_NOT_FOUND_ROUTE.replace(':monitorId', monitorId),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 12
      }
    });
  }
  return null;
};
exports.useMonitorDetailsPage = useMonitorDetailsPage;