"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanUsePublicLocById = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _state = require("../../../state");
var _overview_status = require("../../../state/overview_status");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCanUsePublicLocById = configId => {
  var _kibana$services2, _kibana$services2$app;
  const {
    allConfigs
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    isServiceAllowed
  } = (0, _hooks.useEnablement)();
  const {
    locations: allLocations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const kibana = (0, _public.useKibana)();
  const canUsePublicLocations = (0, _react.useMemo)(() => {
    var _kibana$services, _kibana$services$appl;
    return Boolean((_kibana$services = kibana.services) === null || _kibana$services === void 0 ? void 0 : (_kibana$services$appl = _kibana$services.application) === null || _kibana$services$appl === void 0 ? void 0 : _kibana$services$appl.capabilities.uptime.elasticManagedLocationsEnabled);
  }, [(_kibana$services2 = kibana.services) === null || _kibana$services2 === void 0 ? void 0 : (_kibana$services2$app = _kibana$services2.application) === null || _kibana$services2$app === void 0 ? void 0 : _kibana$services2$app.capabilities.uptime.elasticManagedLocationsEnabled]);
  const managedLocationIds = (0, _react.useMemo)(() => {
    var _allLocations$filter$;
    return new Set((_allLocations$filter$ = allLocations === null || allLocations === void 0 ? void 0 : allLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id)) !== null && _allLocations$filter$ !== void 0 ? _allLocations$filter$ : []);
  }, [allLocations]);
  const hasManagedLocation = (0, _react.useMemo)(() => {
    var _allConfigs$some;
    return (_allConfigs$some = allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.some(mon => mon.configId === configId && managedLocationIds.has(mon.locationId))) !== null && _allConfigs$some !== void 0 ? _allConfigs$some : false;
  }, [allConfigs, configId, managedLocationIds]);
  if (!isServiceAllowed) {
    return false;
  }
  return hasManagedLocation ? canUsePublicLocations : true;
};
exports.useCanUsePublicLocById = useCanUsePublicLocById;