"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSLO = useCreateSLO;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateSLO({
  configId,
  label,
  tags
}) {
  const {
    slo
  } = (0, _public.useKibana)().services;
  const [isSLOFlyoutOpen, setIsSLOFlyoutOpen] = (0, _react.useState)(false);
  const CreateSLOFlyout = slo === null || slo === void 0 ? void 0 : slo.getCreateSLOFlyout({
    initialValues: {
      name: `SLO for monitor ${label}`,
      indicator: {
        type: 'sli.synthetics.availability',
        params: {
          index: _constants.SYNTHETICS_INDEX_PATTERN,
          filter: '',
          monitorIds: [{
            value: configId,
            label
          }],
          projects: [],
          tags: []
        }
      },
      tags: tags || [],
      groupBy: ['monitor.name', 'observer.geo.name', 'monitor.id']
    },
    onClose: () => {
      setIsSLOFlyoutOpen(false);
    }
  });
  return {
    CreateSLOFlyout: isSLOFlyoutOpen ? CreateSLOFlyout : null,
    setIsSLOFlyoutOpen
  };
}