"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeChartDimensionsSelector = void 0;
const compute_axes_sizes_1 = require("./compute_axes_sizes");
const create_selector_1 = require("../../../../state/create_selector");
const get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
const getParentDimension = (state) => state.parentDimensions;
exports.computeChartDimensionsSelector = (0, create_selector_1.createCustomCachedSelector)([getParentDimension, compute_axes_sizes_1.computeAxesSizesSelector, get_chart_theme_1.getChartThemeSelector], (parentDimensions, axesSizes, { heatmap, chartPaddings, chartMargins }) => {
    const chartHeight = parentDimensions.height -
        axesSizes.xAxisTitleVerticalSize -
        axesSizes.xAxisPanelTitleVerticalSize -
        axesSizes.xAxis.height -
        axesSizes.legendHeight -
        heatmap.grid.stroke.width / 2;
    const chartWidth = parentDimensions.width -
        axesSizes.yAxisTitleHorizontalSize -
        axesSizes.yAxisPanelTitleHorizontalSize -
        axesSizes.yAxis.width -
        axesSizes.legendWidth -
        heatmap.grid.stroke.width / 2;
    const paddedTop = parentDimensions.top + heatmap.grid.stroke.width / 2 + chartPaddings.top;
    const paddedLeft = parentDimensions.left + axesSizes.xAxis.left + chartPaddings.left;
    const paddedWidth = chartWidth - chartPaddings.left - chartPaddings.right;
    const paddedHeight = chartHeight - chartPaddings.top - chartPaddings.bottom;
    const top = paddedTop + chartMargins.top;
    const left = paddedLeft + chartMargins.left;
    const width = Math.max(0, paddedWidth - chartMargins.left - chartMargins.right);
    const height = Math.max(0, paddedHeight - chartMargins.bottom - chartMargins.top);
    return {
        leftMargin: NaN,
        chartDimensions: { top, left, width, height },
    };
});
//# sourceMappingURL=compute_chart_dimensions.js.map