"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBubbles = renderBubbles;
const points_1 = require("./points");
const canvas_1 = require("../../../../renderers/canvas");
const utils_1 = require("../../rendering/utils");
function renderBubbles(ctx, bubbles, sharedStyle, rotation, renderingArea, highlightedLegendItem) {
    (0, canvas_1.withContext)(ctx, () => {
        const styles = {};
        const allPoints = bubbles.flatMap(({ value: { seriesIdentifier, points } }) => {
            styles[seriesIdentifier.key] = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
            return points;
        });
        const shouldClip = allPoints[0]?.value.mark !== null;
        (0, points_1.renderPointGroup)(ctx, allPoints, styles, rotation, renderingArea, shouldClip);
    });
}
//# sourceMappingURL=bubbles.js.map