"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExtra = getExtra;
const legend_1 = require("../../common/legend");
const findCurrentValue = (values) => values.find((v) => v.type === legend_1.LegendValue.CurrentAndLastValue || v.type === legend_1.LegendValue.Value);
function getExtra(extraValues, item, totalItems) {
    const { seriesIdentifiers, values, childId, path } = item;
    if (extraValues.size === 0 || seriesIdentifiers.length > 1 || !seriesIdentifiers[0]) {
        return findCurrentValue(values);
    }
    const [{ key }] = seriesIdentifiers;
    const extraValueKey = path.map(({ index }) => index).join('__');
    const itemExtraValues = extraValues.has(extraValueKey) ? extraValues.get(extraValueKey) : extraValues.get(key);
    const actionExtra = childId !== undefined ? itemExtraValues?.get(childId) : undefined;
    return actionExtra ? actionExtra : extraValues.size === totalItems ? findCurrentValue(values) : undefined;
}
//# sourceMappingURL=utils.js.map