"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSettingsSpecSelector = void 0;
const immer_1 = require("immer");
const get_specs_1 = require("./get_specs");
const chart_types_1 = require("../../chart_types");
const default_settings_spec_1 = require("../../specs/default_settings_spec");
const spec_type_1 = require("../../specs/spec_type");
const debounce_1 = require("../../utils/debounce");
const logger_1 = require("../../utils/logger");
const create_selector_1 = require("../create_selector");
const get_specs_from_store_1 = require("../utils/get_specs_from_store");
const DEFAULT_POINTER_UPDATE_DEBOUNCE = 16;
exports.getSettingsSpecSelector = (0, create_selector_1.createCustomCachedSelector)([get_specs_1.getSpecs], getSettingsSpec);
function getSettingsSpec(specs) {
    const settingsSpecs = (0, get_specs_from_store_1.getSpecsFromStore)(specs, chart_types_1.ChartType.Global, spec_type_1.SpecType.Settings);
    const spec = settingsSpecs[0];
    return spec ? validateSpec(spec) : default_settings_spec_1.DEFAULT_SETTINGS_SPEC;
}
function validateSpec(spec) {
    return (0, immer_1.produce)(spec, (draft) => {
        const delay = draft.pointerUpdateDebounce ?? DEFAULT_POINTER_UPDATE_DEBOUNCE;
        if (draft.onPointerUpdate) {
            draft.onPointerUpdate = (0, debounce_1.debounce)(draft.onPointerUpdate, delay);
        }
        if (draft.dow < 1 || draft.dow > 7 || !Number.isInteger(draft.dow)) {
            logger_1.Logger.warn(`Settings.dow option must be an integer from 1 to 7, received ${draft.dow}. Using default of 1.`);
            draft.dow = default_settings_spec_1.settingsBuildProps.defaults.dow;
        }
    });
}
//# sourceMappingURL=get_settings_spec.js.map