"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadSnippet = loadSnippet;
function loadSnippet(_a) {
    var _b = _a.scriptUrl, scriptUrl = _b === void 0 ? 'https://edge.fullstory.com/s/fs.js' : _b, fullStoryOrgId = _a.fullStoryOrgId, _c = _a.host, host = _c === void 0 ? 'fullstory.com' : _c, _d = _a.namespace, namespace = _d === void 0 ? 'FS' : _d, _e = _a.debug, debug = _e === void 0 ? false : _e, captureOnStartup = _a.captureOnStartup;
    window._fs_debug = debug;
    window._fs_host = host;
    window._fs_script = scriptUrl;
    window._fs_org = fullStoryOrgId;
    window._fs_namespace = namespace;
    // Only set it if the option is provided, since documentation doesn't show it as a "normal" thing to set up.
    if (typeof captureOnStartup === 'boolean') {
        window._fs_capture_on_startup = captureOnStartup;
    }
    require('./raw_snippet'); // load and execute the snippet. Moved to a separate file so that we can disable type-checks.
    var fullStoryApi = window[namespace];
    if (!fullStoryApi) {
        throw new Error('FullStory snippet failed to load. Check browser logs for more information.');
    }
    return fullStoryApi;
}
