"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassicServiceLogsStream = ClassicServiceLogsStream;
exports.ServiceLogs = ServiceLogs;
exports.ServiceLogsOverview = ServiceLogsOverview;
exports.getContainerShouldClauses = getContainerShouldClauses;
exports.getInfrastructureFilter = getInfrastructureFilter;
exports.getInfrastructureKQLFilter = getInfrastructureKQLFilter;
exports.getServiceShouldClauses = getServiceShouldClauses;
var _react = _interopRequireWildcard(require("react"));
var _savedSearchComponent = require("@kbn/saved-search-component");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_kibana = require("../../../context/kibana_context/use_kibana");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceLogs() {
  const {
    services: {
      logsShared: {
        LogsOverview
      }
    }
  } = (0, _use_kibana.useKibana)();
  const isLogsOverviewEnabled = LogsOverview.useIsEnabled();
  if (isLogsOverviewEnabled) {
    return /*#__PURE__*/_react.default.createElement(ServiceLogsOverview, null);
  } else {
    return /*#__PURE__*/_react.default.createElement(ClassicServiceLogsStream, null);
  }
}
function ClassicServiceLogsStream() {
  const {
    services: {
      logsDataAccess: {
        services: {
          logSourcesService
        }
      },
      embeddable,
      dataViews,
      data: {
        search: {
          searchSource
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/logs', '/mobile-services/{serviceName}/logs');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/infrastructure_attributes', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end]);
  const logSources = (0, _useAsync.default)(logSourcesService.getFlattenedLogSources);
  const timeRange = (0, _react.useMemo)(() => ({
    from: start,
    to: end
  }), [start, end]);
  const query = (0, _react.useMemo)(() => ({
    language: 'kuery',
    query: getInfrastructureKQLFilter({
      data,
      serviceName,
      environment
    })
  }), [data, serviceName, environment]);
  return logSources.value ? /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, {
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    index: logSources.value,
    timeRange: timeRange,
    query: query,
    height: "60vh",
    displayOptions: {
      solutionNavIdOverride: 'oblt',
      enableDocumentViewer: true,
      enableFilters: false
    }
  }) : null;
}
function ServiceLogsOverview() {
  const {
    services: {
      logsShared
    }
  } = (0, _use_kibana.useKibana)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/logs');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const timeRange = (0, _react.useMemo)(() => ({
    start,
    end
  }), [start, end]);
  const {
    data: logFilters,
    status
  } = (0, _use_fetcher.useFetcher)(async callApmApi => {
    if (start == null || end == null) {
      return;
    }
    const {
      containerIds
    } = await callApmApi('GET /internal/apm/services/{serviceName}/infrastructure_attributes', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          start,
          end
        }
      }
    });
    return [getInfrastructureFilter({
      containerIds,
      environment,
      serviceName
    })];
  }, [environment, kuery, serviceName, start, end]);
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    return /*#__PURE__*/_react.default.createElement(logsShared.LogsOverview, {
      documentFilters: logFilters,
      timeRange: timeRange
    });
  } else if (status === _use_fetcher.FETCH_STATUS.FAILURE) {
    return /*#__PURE__*/_react.default.createElement(logsShared.LogsOverview.ErrorContent, {
      error: new Error('Failed to fetch service details')
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(logsShared.LogsOverview.LoadingContent, null);
  }
}
function getInfrastructureKQLFilter({
  data,
  serviceName,
  environment
}) {
  var _data$containerIds;
  const serviceNameAndEnvironmentCorrelation = environment === _environment_filter_values.ENVIRONMENT_ALL.value ? `${_apm.SERVICE_NAME}: "${serviceName}"` // correlate on service.name only
  : `(${_apm.SERVICE_NAME}: "${serviceName}" and ${_apm.SERVICE_ENVIRONMENT}: "${environment}") or (${_apm.SERVICE_NAME}: "${serviceName}" and not ${_apm.SERVICE_ENVIRONMENT}: *)`; // correlate on service.name + service.environment

  // correlate on container.id
  const containerIdKql = ((_data$containerIds = data === null || data === void 0 ? void 0 : data.containerIds) !== null && _data$containerIds !== void 0 ? _data$containerIds : []).map(id => `${_apm.CONTAINER_ID}: "${id}"`).join(' or ');
  const containerIdCorrelation = containerIdKql ? [`((${containerIdKql}) and not ${_apm.SERVICE_NAME}: *)`] : [];
  return [serviceNameAndEnvironmentCorrelation, ...containerIdCorrelation].join(' or ');
}
function getInfrastructureFilter({
  containerIds,
  environment,
  serviceName
}) {
  return {
    bool: {
      should: [...getServiceShouldClauses({
        environment,
        serviceName
      }), ...getContainerShouldClauses({
        containerIds
      })],
      minimum_should_match: 1
    }
  };
}
function getServiceShouldClauses({
  environment,
  serviceName
}) {
  const serviceNameFilter = {
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  };
  if (environment === _environment_filter_values.ENVIRONMENT_ALL.value) {
    return [serviceNameFilter];
  } else {
    return [{
      bool: {
        filter: [serviceNameFilter, {
          term: {
            [_apm.SERVICE_ENVIRONMENT]: environment
          }
        }]
      }
    }, {
      bool: {
        filter: [serviceNameFilter],
        must_not: [{
          exists: {
            field: _apm.SERVICE_ENVIRONMENT
          }
        }]
      }
    }];
  }
}
function getContainerShouldClauses({
  containerIds = []
}) {
  if (containerIds.length === 0) {
    return [];
  }
  return [{
    bool: {
      filter: [{
        terms: {
          [_apm.CONTAINER_ID]: containerIds
        }
      }],
      must_not: [{
        term: {
          [_apm.SERVICE_NAME]: '*'
        }
      }]
    }
  }];
}