"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmTelemetryEventBasedTypes = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchQuerySubmittedEventType = {
  eventType: _types.TelemetryEventTypes.SEARCH_QUERY_SUBMITTED,
  schema: {
    kueryFields: {
      type: 'array',
      items: {
        type: 'text',
        _meta: {
          description: 'The kuery fields used in the search'
        }
      }
    },
    timerange: {
      type: 'text',
      _meta: {
        description: 'The timerange of the search'
      }
    },
    action: {
      type: 'keyword',
      _meta: {
        description: 'The action performed (e.g., submit, refresh)'
      }
    }
  }
};
const apmTelemetryEventBasedTypes = exports.apmTelemetryEventBasedTypes = [searchQuerySubmittedEventType];