"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceGroupWithOverflowQuery = serviceGroupWithOverflowQuery;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function serviceGroupWithOverflowQuery(serviceGroup) {
  if (serviceGroup) {
    const serviceGroupQuery = (0, _server.kqlQuery)(serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery);
    const otherBucketQuery = (0, _server.termQuery)(_apm.SERVICE_NAME, '_other');
    return [{
      bool: {
        should: [{
          bool: {
            filter: serviceGroupQuery
          }
        }, {
          bool: {
            filter: otherBucketQuery
          }
        }]
      }
    }];
  }
  return [];
}