"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareWebsiteFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _hooks2 = require("./hooks");
var _constants = require("../../../../../i18n/constants");
var _workpad_step = require("./workpad_step");
var _runtime_step = require("./runtime_step");
var _snippets_step = require("./snippets_step");
var _services = require("../../../../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getCopyShareConfigMessage: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.copyShareConfigMessage', {
    defaultMessage: 'Copied share markup to clipboard'
  }),
  getUnknownExportErrorMessage: type => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.unknownExportErrorMessage', {
    defaultMessage: 'Unknown export type: {type}',
    values: {
      type
    }
  }),
  getRuntimeStepTitle: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.downloadRuntimeTitle', {
    defaultMessage: 'Download runtime'
  }),
  getSnippentsStepTitle: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.addSnippetsTitle', {
    defaultMessage: 'Add snippets to website'
  }),
  getStepsDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.description', {
    defaultMessage: 'Follow these steps to share a static version of this workpad on an external website. It will be a visual snapshot of the current workpad, and will not have access to live data.'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.flyoutTitle', {
    defaultMessage: 'Share on a website'
  }),
  getUnsupportedRendererWarning: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderShareMenu.unsupportedRendererWarning', {
    defaultMessage: 'This workpad contains render functions that are not supported by the {CANVAS} Shareable Workpad Runtime. These elements will not be rendered:',
    values: {
      CANVAS: _constants.CANVAS
    }
  }),
  getWorkpadStepTitle: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.downloadWorkpadTitle', {
    defaultMessage: 'Download workpad'
  })
};
const steps = (onDownload, onCopy) => [{
  title: strings.getWorkpadStepTitle(),
  children: /*#__PURE__*/_react.default.createElement(_workpad_step.WorkpadStep, {
    onDownload
  })
}, {
  title: strings.getRuntimeStepTitle(),
  children: /*#__PURE__*/_react.default.createElement(_runtime_step.RuntimeStep, {
    onDownload
  })
}, {
  title: strings.getSnippentsStepTitle(),
  children: /*#__PURE__*/_react.default.createElement(_snippets_step.SnippetsStep, {
    onCopy
  })
}];
const ShareWebsiteFlyout = ({
  onClose,
  unsupportedRenderers,
  renderedWorkpad
}) => {
  const notifyService = (0, _services.useNotifyService)();
  const onCopy = (0, _react.useCallback)(() => notifyService.info(strings.getCopyShareConfigMessage()), [notifyService]);
  const downloadRenderedWorkpad = (0, _hooks.useDownloadRenderedWorkpad)();
  const downloadRuntime = (0, _hooks2.useDownloadRuntime)();
  const downloadZippedRuntime = (0, _hooks2.useDownloadZippedRuntime)();
  const onDownload = (0, _react.useCallback)(type => {
    switch (type) {
      case 'share':
        downloadRenderedWorkpad(renderedWorkpad);
        return;
      case 'shareRuntime':
        downloadRuntime();
        return;
      case 'shareZip':
        downloadZippedRuntime(renderedWorkpad);
        return;
      default:
        throw new Error(strings.getUnknownExportErrorMessage(type));
    }
  }, [downloadRenderedWorkpad, downloadRuntime, downloadZippedRuntime, renderedWorkpad]);
  const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    style: {
      textDecoration: 'underline'
    },
    onClick: () => {
      onDownload('shareZip');
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.canvas.shareWebsiteFlyout.zipDownloadLinkLabel",
    defaultMessage: "download an example {ZIP} file",
    values: {
      ZIP: _constants.ZIP
    }
  }));
  const title = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.canvas.shareWebsiteFlyout.flyoutCalloutDescription",
    defaultMessage: "To try sharing, you can {link} containing this workpad, the {CANVAS} Shareable Workpad runtime, and a sample {HTML} file.",
    values: {
      CANVAS: _constants.CANVAS,
      HTML: _constants.HTML,
      link
    }
  }));
  let warningText = null;
  if (unsupportedRenderers && unsupportedRenderers.length > 0) {
    const warning = [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      key: "text"
    }, /*#__PURE__*/_react.default.createElement("span", null, strings.getUnsupportedRendererWarning()), unsupportedRenderers.map((fn, index) => [/*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      key: `item-${index}`
    }, fn), index < unsupportedRenderers.length - 1 ? ', ' : ''])), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      key: "spacer"
    })];
    warningText = [/*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: warning,
      color: "warning",
      size: "s",
      iconType: "warning",
      key: "callout"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      key: "spacer"
    })];
  }
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => onClose('share'),
    maxWidth: true,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, strings.getTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "Beta",
    color: "accent"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, strings.getStepsDescription())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: title,
    iconType: "info"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), warningText, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps(onDownload, onCopy)
  })));
};
exports.ShareWebsiteFlyout = ShareWebsiteFlyout;