"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMapping = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _field_mapping_row_static = require("./field_mapping_row_static");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldMappingComponent = ({
  actionTypeName,
  isLoading,
  mappings
}) => {
  const sFontSize = (0, _eui.useEuiFontSize)('s').fontSize;
  return mappings.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.FIELD_MAPPING_FIRST_COL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-configure-field-mappings-second-col-label"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.FIELD_MAPPING_SECOND_COL(actionTypeName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.FIELD_MAPPING_THIRD_COL)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "case-configure-field-mappings-row-wrapper",
    css: (0, _react2.css)`
            margin: 10px 0;
            font-size: ${sFontSize};
          `
  }, mappings.map(item => {
    var _item$target;
    return /*#__PURE__*/_react.default.createElement(_field_mapping_row_static.FieldMappingRowStatic, {
      key: `${item.source}`,
      casesField: item.source,
      isLoading: isLoading,
      selectedActionType: item.actionType,
      selectedThirdParty: (_item$target = item.target) !== null && _item$target !== void 0 ? _item$target : 'not_mapped'
    });
  })))) : null;
};
FieldMappingComponent.displayName = 'FieldMapping';
const FieldMapping = exports.FieldMapping = /*#__PURE__*/_react.default.memo(FieldMappingComponent);