"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCaseFileKinds = exports.isRegisteredOwner = void 0;
var _constants = require("../../common/constants");
var _files = require("../../common/files");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOwnerUIName = owner => {
  switch (owner) {
    case _constants.SECURITY_SOLUTION_OWNER:
      return 'Security';
    case _constants.OBSERVABILITY_OWNER:
      return 'Observability';
    case _constants.GENERAL_CASES_OWNER:
      return 'Stack Management';
    default:
      return owner;
  }
};
const buildFileKind = (config, owner) => {
  var _config$maxSize;
  return {
    id: (0, _files.constructFileKindIdByOwner)(owner),
    allowedMimeTypes: config.allowedMimeTypes,
    maxSizeBytes: (_config$maxSize = config.maxSize) !== null && _config$maxSize !== void 0 ? _config$maxSize : _constants.MAX_FILE_SIZE,
    managementUiActions: {
      delete: {
        enabled: false,
        reason: i18n.FILE_DELETE_REASON(getOwnerUIName(owner))
      }
    }
  };
};
const isRegisteredOwner = ownerToCheck => _constants.OWNERS.includes(ownerToCheck);

/**
 * The file kind definition for interacting with the file service for the UI
 */
exports.isRegisteredOwner = isRegisteredOwner;
const createFileKinds = config => {
  const caseFileKinds = new Map();
  for (const owner of _constants.OWNERS) {
    caseFileKinds.set(owner, buildFileKind(config, owner));
  }
  return caseFileKinds;
};
const registerCaseFileKinds = (config, filesSetupPlugin) => {
  const fileKinds = createFileKinds(config);
  for (const fileKind of fileKinds.values()) {
    filesSetupPlugin.registerFileKind(fileKind);
  }
};
exports.registerCaseFileKinds = registerCaseFileKinds;