"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _lodash = require("lodash");
var _column_name_with_tooltip = require("../../components/column_name_with_tooltip");
var _test_subjects = _interopRequireWildcard(require("./test_subjects"));
var TEST_SUBJECTS = _test_subjects;
var _use_change_csp_rule_state = require("./use_change_csp_rule_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesTable = ({
  setPagination,
  perPage: pageSize,
  rules_page: items,
  page,
  total,
  loading,
  error,
  selectedRuleId,
  selectedRules,
  setSelectedRules,
  onRuleClick,
  onSortChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiPagination = {
    pageIndex: page,
    pageSize,
    totalItemCount: total,
    pageSizeOptions: [10, 25, 100]
  };
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const sorting = {
    sort: {
      field: 'metadata.benchmark.rule_number',
      direction: sortDirection
    }
  };
  const onTableChange = ({
    page: pagination,
    sort: sortOrder
  }) => {
    if (!pagination) return;
    if (pagination) setPagination({
      page: pagination.index,
      perPage: pagination.size
    });
    if (sortOrder) {
      setSortDirection(sortOrder.direction);
      onSortChange(sortOrder.direction);
    }
  };
  const rowProps = row => {
    var _row$metadata, _row$metadata2;
    return {
      ['data-test-subj']: TEST_SUBJECTS.getCspBenchmarkRuleTableRowItemTestId((_row$metadata = row.metadata) === null || _row$metadata === void 0 ? void 0 : _row$metadata.id),
      style: {
        background: ((_row$metadata2 = row.metadata) === null || _row$metadata2 === void 0 ? void 0 : _row$metadata2.id) === selectedRuleId ? euiTheme.colors.highlight : undefined
      }
    };
  };
  const [isAllRulesSelectedThisPage, setIsAllRulesSelectedThisPage] = (0, _react.useState)(false);
  const isCurrentPageRulesASubset = (currentPageRulesArray, selectedRulesArray) => {
    let i = 0;
    const newCurrentPageRulesArray = currentPageRulesArray.map(rule => rule.metadata);
    const newSelectedRulesArray = selectedRulesArray.map(rule => rule.metadata);
    while (i < newCurrentPageRulesArray.length) {
      if (!newSelectedRulesArray.includes(newCurrentPageRulesArray[i])) return false;
      i++;
    }
    return true;
  };
  (0, _react.useEffect)(() => {
    if (selectedRules.length >= items.length && items.length > 0 && selectedRules.length > 0) setIsAllRulesSelectedThisPage(true);else setIsAllRulesSelectedThisPage(false);
  }, [items.length, selectedRules.length]);
  const columns = getColumns({
    selectedRules,
    setSelectedRules,
    items,
    setIsAllRulesSelectedThisPage,
    isAllRulesSelectedThisPage,
    isCurrentPageRulesASubset,
    onRuleClick
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_TABLE,
    loading: loading,
    error: error,
    items: items,
    columns: columns,
    pagination: euiPagination,
    onChange: onTableChange,
    itemId: v => v.metadata.id,
    rowProps: rowProps,
    sorting: sorting
  }));
};
exports.RulesTable = RulesTable;
const getColumns = ({
  selectedRules,
  setSelectedRules,
  items,
  isAllRulesSelectedThisPage,
  isCurrentPageRulesASubset,
  onRuleClick
}) => [{
  field: 'action',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: _test_subjects.RULES_TABLE.RULES_ROW_SELECT_ALL_CURRENT_PAGE,
    checked: isCurrentPageRulesASubset(items, selectedRules) && isAllRulesSelectedThisPage,
    onChange: () => {
      const uniqueSelectedRules = (0, _lodash.uniqBy)([...selectedRules, ...items], 'metadata.id');
      const onChangeSelectAllThisPageFn = () => {
        setSelectedRules(uniqueSelectedRules);
      };
      const onChangeDeselectAllThisPageFn = () => {
        setSelectedRules(selectedRules.filter(element => !items.find(item => {
          var _item$metadata, _element$metadata;
          return ((_item$metadata = item.metadata) === null || _item$metadata === void 0 ? void 0 : _item$metadata.id) === ((_element$metadata = element.metadata) === null || _element$metadata === void 0 ? void 0 : _element$metadata.id);
        })));
      };
      return isCurrentPageRulesASubset(items, selectedRules) && isAllRulesSelectedThisPage ? onChangeDeselectAllThisPageFn() : onChangeSelectAllThisPageFn();
    }
  }),
  width: '40px',
  sortable: false,
  render: (_rules, item) => {
    var _item$metadata3, _item$metadata4;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      checked: selectedRules.some(rule => {
        var _rule$metadata, _item$metadata2;
        return ((_rule$metadata = rule.metadata) === null || _rule$metadata === void 0 ? void 0 : _rule$metadata.id) === ((_item$metadata2 = item.metadata) === null || _item$metadata2 === void 0 ? void 0 : _item$metadata2.id);
      }),
      id: `cloud-security-fields-selector-item-${(_item$metadata3 = item.metadata) === null || _item$metadata3 === void 0 ? void 0 : _item$metadata3.id}`,
      "data-test-subj": `cloud-security-fields-selector-item-${(_item$metadata4 = item.metadata) === null || _item$metadata4 === void 0 ? void 0 : _item$metadata4.id}`,
      onChange: e => {
        const isChecked = e.target.checked;
        return isChecked ? setSelectedRules([...selectedRules, item]) : setSelectedRules(selectedRules.filter(rule => {
          var _rule$metadata2, _item$metadata5;
          return ((_rule$metadata2 = rule.metadata) === null || _rule$metadata2 === void 0 ? void 0 : _rule$metadata2.id) !== ((_item$metadata5 = item.metadata) === null || _item$metadata5 === void 0 ? void 0 : _item$metadata5.id);
        }));
      }
    });
  }
}, {
  field: 'metadata.benchmark.rule_number',
  name: _i18n.i18n.translate('xpack.csp.rules.rulesTable.ruleNumberColumnLabel', {
    defaultMessage: 'Rule Number'
  }),
  width: '120px',
  sortable: true
}, {
  field: 'metadata.name',
  name: _i18n.i18n.translate('xpack.csp.rules.rulesTable.nameColumnLabel', {
    defaultMessage: 'Name'
  }),
  width: '60%',
  truncateText: true,
  render: (name, rule) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "eui-textTruncate",
    title: name,
    onClick: e => {
      e.stopPropagation();
      onRuleClick(rule.metadata.id);
    },
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_TABLE_ROW_ITEM_NAME
  }, name)
}, {
  field: 'metadata.section',
  name: _i18n.i18n.translate('xpack.csp.rules.rulesTable.cisSectionColumnLabel', {
    defaultMessage: 'CIS Section'
  }),
  width: '24%'
}, {
  field: 'metadata.name',
  name: /*#__PURE__*/_react.default.createElement(_column_name_with_tooltip.ColumnNameWithTooltip, {
    columnName: _i18n.i18n.translate('xpack.csp.rules.rulesTable.enabledColumnLabel', {
      defaultMessage: 'Enabled'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.csp.rules.rulesTable.enabledColumnTooltip', {
      defaultMessage: `Disabling a rule will also disable its associated detection rules and alerts. Enabling it again does not automatically re-enable them`
    })
  }),
  align: 'right',
  width: '100px',
  truncateText: true,
  render: (_name, rule) => /*#__PURE__*/_react.default.createElement(RuleStateSwitch, {
    rule: rule
  })
}];
const RuleStateSwitch = ({
  rule
}) => {
  const isRuleMuted = (rule === null || rule === void 0 ? void 0 : rule.state) === 'muted';
  const nextRuleState = isRuleMuted ? 'unmute' : 'mute';
  const {
    mutate: mutateRulesStates
  } = (0, _use_change_csp_rule_state.useChangeCspRuleState)();
  const rulesObjectRequest = {
    benchmark_id: rule === null || rule === void 0 ? void 0 : rule.metadata.benchmark.id,
    benchmark_version: rule === null || rule === void 0 ? void 0 : rule.metadata.benchmark.version,
    /* Rule number always exists from 8.7 */
    rule_number: rule === null || rule === void 0 ? void 0 : rule.metadata.benchmark.rule_number,
    rule_id: rule === null || rule === void 0 ? void 0 : rule.metadata.id
  };
  const changeCspRuleStateFn = async () => {
    if (rule !== null && rule !== void 0 && rule.metadata.benchmark.rule_number) {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.CHANGE_RULE_STATE);
      mutateRulesStates({
        newState: nextRuleState,
        ruleIds: [rulesObjectRequest]
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    className: "eui-textTruncate",
    checked: !isRuleMuted,
    onChange: changeCspRuleStateFn,
    "data-test-subj": _test_subjects.RULES_TABLE.RULES_ROWS_ENABLE_SWITCH_BUTTON,
    label: "",
    compressed: true
  })));
};